/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.ast.factories;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.commons.enums.ResultCode;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.testutils.PMMLModelTestUtils;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.ast.factories.KiePMMLCompoundPredicateASTFactory;
import org.kie.pmml.models.drools.ast.factories.PredicateASTFactoryData;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.kie.pmml.models.drools.utils.KiePMMLASTTestUtils;

public class KiePMMLCompoundPredicateASTFactoryTest {
    @Test
    public void declareRuleFromCompoundPredicateAndOrXorFinalLeaf() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        List<SimplePredicate> predicates = this.getSimplePredicates(fieldTypeMap);
        String parentPath = "_will play";
        String currentRule = "_will play_will play";
        String result = "RESULT";
        block5: for (CompoundPredicate.BooleanOperator operator : CompoundPredicate.BooleanOperator.values()) {
            if (operator.equals((Object)CompoundPredicate.BooleanOperator.SURROGATE)) continue;
            CompoundPredicate compoundPredicate = new CompoundPredicate();
            compoundPredicate.setBooleanOperator(operator);
            predicates.forEach(xva$0 -> compoundPredicate.addPredicates(new Predicate[]{xva$0}));
            ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
            PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)compoundPredicate, Collections.emptyList(), rules, parentPath, currentRule, fieldTypeMap);
            KiePMMLCompoundPredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromCompoundPredicate((Object)result, true);
            Assert.assertEquals((long)1L, (long)rules.size());
            KiePMMLDroolsRule retrieved = (KiePMMLDroolsRule)rules.get(0);
            Assert.assertNotNull((Object)retrieved);
            Assert.assertEquals((Object)currentRule, (Object)retrieved.getName());
            Assert.assertEquals((Object)"DONE", (Object)retrieved.getStatusToSet());
            Assert.assertEquals((Object)String.format("status == \"%s\"", parentPath), (Object)retrieved.getStatusConstraint());
            Assert.assertEquals((Object)result, (Object)retrieved.getResult());
            Assert.assertEquals((Object)ResultCode.OK, (Object)retrieved.getResultCode());
            switch (compoundPredicate.getBooleanOperator()) {
                case AND: {
                    Assert.assertNotNull((Object)retrieved.getAndConstraints());
                    continue block5;
                }
                case OR: {
                    Assert.assertNotNull((Object)retrieved.getOrConstraints());
                    continue block5;
                }
                case XOR: {
                    Assert.assertNotNull((Object)retrieved.getXorConstraints());
                    continue block5;
                }
            }
        }
    }

    @Test
    public void declareRuleFromCompoundPredicateAndOrXorNotFinalLeaf() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        List<SimplePredicate> predicates = this.getSimplePredicates(fieldTypeMap);
        String parentPath = "_will play";
        String currentRule = "_will play_will play";
        String result = "RESULT";
        block5: for (CompoundPredicate.BooleanOperator operator : CompoundPredicate.BooleanOperator.values()) {
            if (operator.equals((Object)CompoundPredicate.BooleanOperator.SURROGATE)) continue;
            CompoundPredicate compoundPredicate = new CompoundPredicate();
            compoundPredicate.setBooleanOperator(operator);
            predicates.forEach(xva$0 -> compoundPredicate.addPredicates(new Predicate[]{xva$0}));
            ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
            PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)compoundPredicate, Collections.emptyList(), rules, parentPath, currentRule, fieldTypeMap);
            KiePMMLCompoundPredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromCompoundPredicate((Object)result, false);
            Assert.assertEquals((long)1L, (long)rules.size());
            KiePMMLDroolsRule retrieved = (KiePMMLDroolsRule)rules.get(0);
            Assert.assertNotNull((Object)retrieved);
            Assert.assertEquals((Object)currentRule, (Object)retrieved.getName());
            Assert.assertEquals((Object)currentRule, (Object)retrieved.getStatusToSet());
            Assert.assertEquals((Object)String.format("status == \"%s\"", parentPath), (Object)retrieved.getStatusConstraint());
            switch (compoundPredicate.getBooleanOperator()) {
                case AND: {
                    Assert.assertNotNull((Object)retrieved.getAndConstraints());
                    continue block5;
                }
                case OR: {
                    Assert.assertNotNull((Object)retrieved.getOrConstraints());
                    continue block5;
                }
                case XOR: {
                    Assert.assertNotNull((Object)retrieved.getXorConstraints());
                    continue block5;
                }
            }
        }
    }

    @Test
    public void declareRuleFromCompoundPredicateSurrogateFinalLeaf() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        List<SimplePredicate> predicates = this.getSimplePredicates(fieldTypeMap);
        String parentPath = "_will play";
        String currentRule = "_will play_will play";
        String result = "RESULT";
        CompoundPredicate compoundPredicate = new CompoundPredicate();
        compoundPredicate.setBooleanOperator(CompoundPredicate.BooleanOperator.SURROGATE);
        predicates.forEach(xva$0 -> compoundPredicate.addPredicates(new Predicate[]{xva$0}));
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)compoundPredicate, Collections.emptyList(), rules, parentPath, currentRule, fieldTypeMap);
        KiePMMLCompoundPredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromCompoundPredicate((Object)result, true);
        int expectedRules = predicates.size() * 2 + 1;
        Assert.assertEquals((long)expectedRules, (long)rules.size());
        String agendaActivationGroup = String.format("%s_surrogate", currentRule);
        for (KiePMMLDroolsRule retrieved : rules) {
            String ruleName = retrieved.getName();
            if (ruleName.contains("_surrogate_")) {
                String[] ruleNameParts = ruleName.split("_surrogate_");
                String generatedTypePart = ruleNameParts[1];
                boolean isTrueRule = generatedTypePart.endsWith("_TRUE");
                String generatedType = generatedTypePart.replace("_TRUE", "").replace("_FALSE", "");
                Optional<String> fieldName = fieldTypeMap.entrySet().stream().filter(entry -> generatedType.equals(((KiePMMLOriginalTypeGeneratedType)entry.getValue()).getGeneratedType())).map(Map.Entry::getKey).findFirst();
                if (!fieldName.isPresent()) continue;
                SimplePredicate mappedPredicate = predicates.stream().filter(pred -> ((String)fieldName.get()).equals(pred.getField().getValue())).findFirst().orElse(null);
                Assert.assertNotNull((Object)mappedPredicate);
                Assert.assertNull((Object)retrieved.getStatusConstraint());
                Assert.assertEquals((Object)agendaActivationGroup, (Object)retrieved.getActivationGroup());
                Assert.assertEquals((Object)agendaActivationGroup, (Object)retrieved.getAgendaGroup());
                if (isTrueRule) {
                    Assert.assertEquals((Object)"DONE", (Object)retrieved.getStatusToSet());
                    Assert.assertEquals((Object)result, (Object)retrieved.getResult());
                    Assert.assertEquals((Object)ResultCode.OK, (Object)retrieved.getResultCode());
                    continue;
                }
                Assert.assertEquals((Object)parentPath, (Object)retrieved.getStatusToSet());
                Assert.assertNull((Object)retrieved.getResult());
                Assert.assertNull((Object)retrieved.getResultCode());
                continue;
            }
            Assert.assertNotNull((Object)retrieved.getStatusConstraint());
            Assert.assertEquals((Object)String.format("status == \"%s\"", parentPath), (Object)retrieved.getStatusConstraint());
            Assert.assertEquals((Object)agendaActivationGroup, (Object)retrieved.getFocusedAgendaGroup());
            Assert.assertNull((Object)retrieved.getStatusToSet());
            Assert.assertNull((Object)retrieved.getResult());
            Assert.assertNull((Object)retrieved.getResultCode());
        }
    }

    @Test
    public void declareRuleFromCompoundPredicateSurrogateNotFinalLeaf() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        List<SimplePredicate> predicates = this.getSimplePredicates(fieldTypeMap);
        String parentPath = "_will play";
        String currentRule = "_will play_will play";
        String result = "RESULT";
        CompoundPredicate compoundPredicate = new CompoundPredicate();
        compoundPredicate.setBooleanOperator(CompoundPredicate.BooleanOperator.SURROGATE);
        predicates.forEach(xva$0 -> compoundPredicate.addPredicates(new Predicate[]{xva$0}));
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)compoundPredicate, Collections.emptyList(), rules, parentPath, currentRule, fieldTypeMap);
        KiePMMLCompoundPredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromCompoundPredicate((Object)result, false);
        int expectedRules = predicates.size() * 2 + 1;
        Assert.assertEquals((long)expectedRules, (long)rules.size());
        String agendaActivationGroup = String.format("%s_surrogate", currentRule);
        for (KiePMMLDroolsRule retrieved : rules) {
            String ruleName = retrieved.getName();
            if (ruleName.contains("_surrogate_")) {
                String[] ruleNameParts = ruleName.split("_surrogate_");
                String generatedTypePart = ruleNameParts[1];
                boolean isTrueRule = generatedTypePart.endsWith("_TRUE");
                String generatedType = generatedTypePart.replace("_TRUE", "").replace("_FALSE", "");
                Optional<String> fieldName = fieldTypeMap.entrySet().stream().filter(entry -> generatedType.equals(((KiePMMLOriginalTypeGeneratedType)entry.getValue()).getGeneratedType())).map(Map.Entry::getKey).findFirst();
                if (!fieldName.isPresent()) continue;
                SimplePredicate mappedPredicate = predicates.stream().filter(pred -> ((String)fieldName.get()).equals(pred.getField().getValue())).findFirst().orElse(null);
                Assert.assertNotNull((Object)mappedPredicate);
                Assert.assertNull((Object)retrieved.getStatusConstraint());
                Assert.assertEquals((Object)agendaActivationGroup, (Object)retrieved.getActivationGroup());
                Assert.assertEquals((Object)agendaActivationGroup, (Object)retrieved.getAgendaGroup());
                if (isTrueRule) {
                    Assert.assertEquals((Object)currentRule, (Object)retrieved.getStatusToSet());
                    Assert.assertNull((Object)retrieved.getResult());
                    Assert.assertNull((Object)retrieved.getResultCode());
                    continue;
                }
                Assert.assertEquals((Object)parentPath, (Object)retrieved.getStatusToSet());
                Assert.assertNull((Object)retrieved.getResult());
                Assert.assertNull((Object)retrieved.getResultCode());
                continue;
            }
            Assert.assertNotNull((Object)retrieved.getStatusConstraint());
            Assert.assertEquals((Object)String.format("status == \"%s\"", parentPath), (Object)retrieved.getStatusConstraint());
            Assert.assertEquals((Object)agendaActivationGroup, (Object)retrieved.getFocusedAgendaGroup());
            Assert.assertNull((Object)retrieved.getStatusToSet());
            Assert.assertNull((Object)retrieved.getResult());
            Assert.assertNull((Object)retrieved.getResultCode());
        }
    }

    private List<SimplePredicate> getSimplePredicates(Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        return IntStream.range(0, 2).mapToObj(index -> {
            String predicateName = "SIMPLEPREDICATE-" + index;
            fieldTypeMap.put(predicateName, new KiePMMLOriginalTypeGeneratedType(DataType.STRING.value(), KiePMMLModelUtils.getSanitizedClassName((String)predicateName.toUpperCase())));
            return PMMLModelTestUtils.getSimplePredicate((String)predicateName, (Object)("VALUE-" + index), (SimplePredicate.Operator)SimplePredicate.Operator.LESS_THAN);
        }).collect(Collectors.toList());
    }
}

