/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.commons.factories;

import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.IntStream;
import org.drools.compiler.lang.api.DescrFactory;
import org.drools.compiler.lang.api.PackageDescrBuilder;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.compiler.lang.descr.TypeFieldDescr;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsType;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrTestUtils;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrTypesFactory;

public class KiePMMLDescrTypesFactoryTest {
    private static final String PACKAGE_NAME = "package";
    private PackageDescrBuilder builder;

    @Before
    public void setUp() throws Exception {
        this.builder = DescrFactory.newPackage().name(PACKAGE_NAME);
    }

    @Test
    public void declareTypes() {
        ArrayList<KiePMMLDroolsType> types = new ArrayList<KiePMMLDroolsType>();
        types.add(KiePMMLDescrTestUtils.getDroolsType());
        types.add(KiePMMLDescrTestUtils.getDottedDroolsType());
        Assert.assertTrue((boolean)((PackageDescr)this.builder.getDescr()).getTypeDeclarations().isEmpty());
        KiePMMLDescrTypesFactory.factory((PackageDescrBuilder)this.builder).declareTypes(types);
        Assert.assertEquals((long)2L, (long)((PackageDescr)this.builder.getDescr()).getTypeDeclarations().size());
        IntStream.range(0, types.size()).forEach(i -> this.commonVerifyTypeDeclarationDescr((KiePMMLDroolsType)Objects.requireNonNull(types.get(i)), (TypeDeclarationDescr)((PackageDescr)this.builder.getDescr()).getTypeDeclarations().get(i)));
    }

    @Test
    public void declareType() {
        KiePMMLDroolsType type = KiePMMLDescrTestUtils.getDroolsType();
        KiePMMLDescrTypesFactory.factory((PackageDescrBuilder)this.builder).declareType(type);
        Assert.assertEquals((long)1L, (long)((PackageDescr)this.builder.getDescr()).getTypeDeclarations().size());
        this.commonVerifyTypeDeclarationDescr(type, (TypeDeclarationDescr)((PackageDescr)this.builder.getDescr()).getTypeDeclarations().get(0));
    }

    private void commonVerifyTypeDeclarationDescr(KiePMMLDroolsType type, TypeDeclarationDescr typeDeclarationDescr) {
        String expectedGeneratedType = type.getName();
        String expectedMappedOriginalType = type.getType();
        Assert.assertEquals((Object)expectedGeneratedType, (Object)typeDeclarationDescr.getTypeName());
        Assert.assertEquals((long)1L, (long)typeDeclarationDescr.getFields().size());
        Assert.assertTrue((boolean)typeDeclarationDescr.getFields().containsKey("value"));
        Assert.assertEquals((Object)expectedMappedOriginalType, (Object)((TypeFieldDescr)typeDeclarationDescr.getFields().get("value")).getPattern().getObjectType());
    }
}

