/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.commons.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.models.drools.commons.model.KiePMMLDroolsModelWithSources;

public class KiePMMLDroolsModelWithSourcesTest {
    private static final KieBase KIE_BASE = new KnowledgeBaseImpl("PMML", null);
    private static final String MODEL_NAME = "modelNaMe";
    private static final String KMODULEPACKAGENAME = KiePMMLModelUtils.getSanitizedPackageName((String)"modelNaMe");
    private static final String PKGUUID = "PKGUUID";
    private static final Map<String, String> SOURCES_MAP = new HashMap<String, String>();
    private static final Map<String, String> RULES_SOURCES_MAP = new HashMap<String, String>();
    private KiePMMLDroolsModelWithSources kiePMMLDroolsModelWithSources;

    @Before
    public void setup() {
        this.kiePMMLDroolsModelWithSources = new KiePMMLDroolsModelWithSources(MODEL_NAME, KMODULEPACKAGENAME, PKGUUID, SOURCES_MAP, RULES_SOURCES_MAP);
    }

    @Test
    public void constructor() {
        Assert.assertEquals((Object)MODEL_NAME, (Object)this.kiePMMLDroolsModelWithSources.getName());
    }

    @Test(expected=KiePMMLException.class)
    public void evaluate() {
        this.kiePMMLDroolsModelWithSources.evaluate((Object)KIE_BASE, Collections.emptyMap());
    }

    @Test(expected=KiePMMLException.class)
    public void getOutputFieldsMap() {
        this.kiePMMLDroolsModelWithSources.getOutputFieldsMap();
    }

    @Test
    public void getSourcesMap() {
        Assert.assertEquals(SOURCES_MAP, (Object)this.kiePMMLDroolsModelWithSources.getSourcesMap());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void addToGetSourcesMap() {
        Map retrieved = this.kiePMMLDroolsModelWithSources.getSourcesMap();
        retrieved.put("KEY", "VALUE");
    }

    @Test
    public void addSourceMap() {
        Map retrieved = this.kiePMMLDroolsModelWithSources.getSourcesMap();
        Assert.assertTrue((boolean)retrieved.isEmpty());
        this.kiePMMLDroolsModelWithSources.addSourceMap("KEY", "VALUE");
        retrieved = this.kiePMMLDroolsModelWithSources.getSourcesMap();
        Assert.assertTrue((boolean)retrieved.containsKey("KEY"));
        Assert.assertEquals((Object)"VALUE", retrieved.get("KEY"));
    }

    @Test
    public void getKModulePackageName() {
        Assert.assertEquals((Object)KMODULEPACKAGENAME, (Object)this.kiePMMLDroolsModelWithSources.getKModulePackageName());
    }
}

