/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.utils;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.tree.TreeModel;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.commons.mocks.HasClassLoaderMock;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.drools.dto.DroolsCompilationDTO;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.kie.pmml.models.drools.utils.KiePMMLDroolsModelFactoryUtils;

public class KiePMMLDroolsModelFactoryUtilsTest {
    private static final String TEMPLATE_SOURCE = "Template.tmpl";
    private static final String TEMPLATE_CLASS_NAME = "Template";
    private static CompilationUnit COMPILATION_UNIT;
    private static ClassOrInterfaceDeclaration MODEL_TEMPLATE;

    @BeforeClass
    public static void setup() {
        COMPILATION_UNIT = JavaParserUtils.getFromFileName((String)TEMPLATE_SOURCE);
        MODEL_TEMPLATE = (ClassOrInterfaceDeclaration)COMPILATION_UNIT.getClassByName(TEMPLATE_CLASS_NAME).get();
    }

    @Test
    public void getKiePMMLModelCompilationUnit() {
        DataDictionary dataDictionary = new DataDictionary();
        String targetFieldString = "target.field";
        FieldName targetFieldName = FieldName.create((String)targetFieldString);
        dataDictionary.addDataFields(new DataField[]{new DataField(targetFieldName, OpType.CONTINUOUS, DataType.DOUBLE)});
        String modelName = "ModelName";
        TreeModel model = new TreeModel();
        model.setModelName(modelName);
        model.setMiningFunction(MiningFunction.CLASSIFICATION);
        MiningField targetMiningField = new MiningField(targetFieldName);
        targetMiningField.setUsageType(MiningField.UsageType.TARGET);
        MiningSchema miningSchema = new MiningSchema();
        miningSchema.addMiningFields(new MiningField[]{targetMiningField});
        model.setMiningSchema(miningSchema);
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        fieldTypeMap.put(targetFieldString, new KiePMMLOriginalTypeGeneratedType(targetFieldString, KiePMMLModelUtils.getSanitizedClassName((String)targetFieldString)));
        String packageName = "net.test";
        PMML pmml = new PMML();
        pmml.setDataDictionary(dataDictionary);
        pmml.addModels(new Model[]{model});
        CommonCompilationDTO source = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)packageName, (PMML)pmml, (Model)model, (HasClassLoader)new HasClassLoaderMock());
        DroolsCompilationDTO droolsCompilationDTO = DroolsCompilationDTO.fromCompilationDTO((CompilationDTO)source, fieldTypeMap);
        CompilationUnit retrieved = KiePMMLDroolsModelFactoryUtils.getKiePMMLModelCompilationUnit((DroolsCompilationDTO)droolsCompilationDTO, (String)TEMPLATE_SOURCE, (String)TEMPLATE_CLASS_NAME);
        Assertions.assertThat((String)((PackageDeclaration)retrieved.getPackageDeclaration().get()).getNameAsString()).isEqualTo(droolsCompilationDTO.getPackageName());
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)((ClassOrInterfaceDeclaration)retrieved.getClassByName(modelName).get()).getDefaultConstructor().get();
        MINING_FUNCTION miningFunction = MINING_FUNCTION.CLASSIFICATION;
        PMML_MODEL pmmlModel = PMML_MODEL.byName((String)model.getClass().getSimpleName());
        HashMap<String, Object> assignExpressionMap = new HashMap<String, Object>();
        assignExpressionMap.put("targetField", new StringLiteralExpr(targetFieldString));
        assignExpressionMap.put("miningFunction", new NameExpr(miningFunction.getClass().getName() + "." + miningFunction.name()));
        assignExpressionMap.put("pmmlMODEL", new NameExpr(pmmlModel.getClass().getName() + "." + pmmlModel.name()));
        String expectedKModulePackageName = KiePMMLModelUtils.getSanitizedPackageName((String)(packageName + "." + modelName));
        assignExpressionMap.put("kModulePackageName", new StringLiteralExpr(expectedKModulePackageName));
        Assertions.assertThat((boolean)CodegenTestUtils.commonEvaluateAssignExpr((BlockStmt)constructorDeclaration.getBody(), assignExpressionMap)).isTrue();
        int expectedMethodCallExprs = assignExpressionMap.size() + fieldTypeMap.size() + 1;
        this.commonEvaluateFieldTypeMap(constructorDeclaration.getBody(), fieldTypeMap, expectedMethodCallExprs);
    }

    @Test
    public void setConstructor() {
        TreeModel model = new TreeModel();
        PMML_MODEL pmmlModel = PMML_MODEL.byName((String)model.getClass().getSimpleName());
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)MODEL_TEMPLATE.getDefaultConstructor().get();
        SimpleName tableName = new SimpleName("TABLE_NAME");
        String targetField = "TARGET_FIELD";
        MINING_FUNCTION miningFunction = MINING_FUNCTION.CLASSIFICATION;
        String kModulePackageName = KiePMMLModelUtils.getSanitizedPackageName((String)"kModulePackageName");
        KiePMMLDroolsModelFactoryUtils.setConstructor((Model)model, (ConstructorDeclaration)constructorDeclaration, (SimpleName)tableName, (String)targetField, (MINING_FUNCTION)miningFunction, (String)kModulePackageName);
        HashMap superInvocationExpressionsMap = new HashMap();
        HashMap<String, Object> assignExpressionMap = new HashMap<String, Object>();
        assignExpressionMap.put("targetField", new StringLiteralExpr(targetField));
        assignExpressionMap.put("miningFunction", new NameExpr(miningFunction.getClass().getName() + "." + miningFunction.name()));
        assignExpressionMap.put("pmmlMODEL", new NameExpr(pmmlModel.getClass().getName() + "." + pmmlModel.name()));
        assignExpressionMap.put("kModulePackageName", new StringLiteralExpr(kModulePackageName));
        Assertions.assertThat((boolean)CodegenTestUtils.commonEvaluateConstructor((ConstructorDeclaration)constructorDeclaration, (String)tableName.asString(), superInvocationExpressionsMap, assignExpressionMap)).isTrue();
    }

    @Test
    public void addFieldTypeMapPopulation() {
        BlockStmt blockStmt = new BlockStmt();
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        IntStream.range(0, 3).forEach(index -> {
            String key = "KEY-" + index;
            KiePMMLOriginalTypeGeneratedType value = new KiePMMLOriginalTypeGeneratedType("ORIGINALTYPE-" + index, "GENERATEDTYPE-" + index);
            fieldTypeMap.put(key, value);
        });
        KiePMMLDroolsModelFactoryUtils.addFieldTypeMapPopulation((BlockStmt)blockStmt, fieldTypeMap);
        this.commonEvaluateFieldTypeMap(blockStmt, fieldTypeMap, fieldTypeMap.size());
    }

    private void commonEvaluateFieldTypeMap(BlockStmt blockStmt, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap, int expectedMethodCallSize) {
        List<MethodCallExpr> retrieved = this.getMethodCallExprList(blockStmt, expectedMethodCallSize, "fieldTypeMap", "put");
        for (Map.Entry<String, KiePMMLOriginalTypeGeneratedType> entry : fieldTypeMap.entrySet()) {
            Assertions.assertThat((boolean)retrieved.stream().map(MethodCallExpr::getArguments).anyMatch(arguments -> this.evaluateFieldTypeMapPopulation(entry, (NodeList<Expression>)arguments))).isTrue();
        }
    }

    private boolean evaluateFieldTypeMapPopulation(Map.Entry<String, KiePMMLOriginalTypeGeneratedType> entry, NodeList<Expression> arguments) {
        boolean toReturn = arguments.size() == 2;
        Expression firstArgument = (Expression)arguments.get(0);
        Expression secondArgument = (Expression)arguments.get(1);
        toReturn &= firstArgument.isStringLiteralExpr() && ((StringLiteralExpr)firstArgument).getValue().equals(entry.getKey());
        return toReturn &= secondArgument.isObjectCreationExpr() && ((ObjectCreationExpr)secondArgument).getArgument(0).isStringLiteralExpr() && ((StringLiteralExpr)((ObjectCreationExpr)secondArgument).getArgument(0)).getValue().equals(entry.getValue().getOriginalType()) && ((ObjectCreationExpr)secondArgument).getArgument(1).isStringLiteralExpr() && ((StringLiteralExpr)((ObjectCreationExpr)secondArgument).getArgument(1)).getValue().equals(entry.getValue().getGeneratedType());
    }

    private List<MethodCallExpr> getMethodCallExprList(BlockStmt blockStmt, int expectedSize, String scope, String method) {
        Stream<Statement> statementStream = this.getStatementStream(blockStmt, expectedSize);
        return statementStream.filter(Statement::isExpressionStmt).map(expressionStmt -> ((ExpressionStmt)expressionStmt).getExpression()).filter(expression -> expression instanceof MethodCallExpr).map(expression -> (MethodCallExpr)expression).filter(methodCallExpr -> this.evaluateMethodCallExpr((MethodCallExpr)methodCallExpr, scope, method)).collect(Collectors.toList());
    }

    private boolean evaluateMethodCallExpr(MethodCallExpr methodCallExpr, String scope, String method) {
        return methodCallExpr.getScope().isPresent() && ((Expression)methodCallExpr.getScope().get()).isNameExpr() && ((NameExpr)methodCallExpr.getScope().get()).getName().asString().equals(scope) && methodCallExpr.getName().asString().equals(method);
    }

    private Stream<Statement> getStatementStream(BlockStmt blockStmt, int expectedSize) {
        NodeList statements = blockStmt.getStatements();
        Assertions.assertThat((List)statements).hasSize(expectedSize);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(statements.iterator(), 16), false);
    }
}

