/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.ast.factories;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.ResultCode;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.api.testutils.PMMLModelTestUtils;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.ast.factories.KiePMMLCompoundPredicateASTFactory;
import org.kie.pmml.models.drools.ast.factories.PredicateASTFactoryData;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.kie.pmml.models.drools.utils.KiePMMLASTTestUtils;

public class KiePMMLCompoundPredicateASTFactoryTest {
    @Test
    void declareRuleFromCompoundPredicateAndOrXorFinalLeaf() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        List<SimplePredicate> predicates = this.getSimplePredicates(fieldTypeMap);
        String parentPath = "_will play";
        String currentRule = "_will play_will play";
        String result = "RESULT";
        block5: for (CompoundPredicate.BooleanOperator operator : CompoundPredicate.BooleanOperator.values()) {
            if (operator.equals((Object)CompoundPredicate.BooleanOperator.SURROGATE)) continue;
            CompoundPredicate compoundPredicate = new CompoundPredicate();
            compoundPredicate.setBooleanOperator(operator);
            predicates.forEach(xva$0 -> compoundPredicate.addPredicates(new Predicate[]{xva$0}));
            ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
            PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)compoundPredicate, Collections.emptyList(), rules, parentPath, currentRule, fieldTypeMap);
            KiePMMLCompoundPredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromCompoundPredicate((Object)result, true);
            Assertions.assertThat(rules).hasSize(1);
            KiePMMLDroolsRule retrieved = (KiePMMLDroolsRule)rules.get(0);
            Assertions.assertThat((Object)retrieved).isNotNull();
            Assertions.assertThat((String)retrieved.getName()).isEqualTo(currentRule);
            Assertions.assertThat((String)retrieved.getStatusToSet()).isEqualTo("DONE");
            Assertions.assertThat((String)retrieved.getStatusConstraint()).isEqualTo(String.format("status == \"%s\"", parentPath));
            Assertions.assertThat((Object)retrieved.getResult()).isEqualTo((Object)result);
            Assertions.assertThat((Comparable)retrieved.getResultCode()).isEqualTo((Object)ResultCode.OK);
            switch (compoundPredicate.getBooleanOperator()) {
                case AND: {
                    Assertions.assertThat((List)retrieved.getAndConstraints()).isNotNull();
                    continue block5;
                }
                case OR: {
                    Assertions.assertThat((List)retrieved.getOrConstraints()).isNotNull();
                    continue block5;
                }
                case XOR: {
                    Assertions.assertThat((List)retrieved.getXorConstraints()).isNotNull();
                    continue block5;
                }
            }
        }
    }

    @Test
    void declareRuleFromCompoundPredicateAndOrXorNotFinalLeaf() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        List<SimplePredicate> predicates = this.getSimplePredicates(fieldTypeMap);
        String parentPath = "_will play";
        String currentRule = "_will play_will play";
        String result = "RESULT";
        block5: for (CompoundPredicate.BooleanOperator operator : CompoundPredicate.BooleanOperator.values()) {
            if (operator.equals((Object)CompoundPredicate.BooleanOperator.SURROGATE)) continue;
            CompoundPredicate compoundPredicate = new CompoundPredicate();
            compoundPredicate.setBooleanOperator(operator);
            predicates.forEach(xva$0 -> compoundPredicate.addPredicates(new Predicate[]{xva$0}));
            ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
            PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)compoundPredicate, Collections.emptyList(), rules, parentPath, currentRule, fieldTypeMap);
            KiePMMLCompoundPredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromCompoundPredicate((Object)result, false);
            Assertions.assertThat(rules).hasSize(1);
            KiePMMLDroolsRule retrieved = (KiePMMLDroolsRule)rules.get(0);
            Assertions.assertThat((Object)retrieved).isNotNull();
            Assertions.assertThat((String)retrieved.getName()).isEqualTo(currentRule);
            Assertions.assertThat((String)retrieved.getStatusToSet()).isEqualTo(currentRule);
            Assertions.assertThat((String)retrieved.getStatusConstraint()).isEqualTo(String.format("status == \"%s\"", parentPath));
            switch (compoundPredicate.getBooleanOperator()) {
                case AND: {
                    Assertions.assertThat((List)retrieved.getAndConstraints()).isNotNull();
                    continue block5;
                }
                case OR: {
                    Assertions.assertThat((List)retrieved.getOrConstraints()).isNotNull();
                    continue block5;
                }
                case XOR: {
                    Assertions.assertThat((List)retrieved.getXorConstraints()).isNotNull();
                    continue block5;
                }
            }
        }
    }

    @Test
    void declareRuleFromCompoundPredicateSurrogateFinalLeaf() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        List<SimplePredicate> predicates = this.getSimplePredicates(fieldTypeMap);
        String parentPath = "_will play";
        String currentRule = "_will play_will play";
        String result = "RESULT";
        CompoundPredicate compoundPredicate = new CompoundPredicate();
        compoundPredicate.setBooleanOperator(CompoundPredicate.BooleanOperator.SURROGATE);
        predicates.forEach(xva$0 -> compoundPredicate.addPredicates(new Predicate[]{xva$0}));
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)compoundPredicate, Collections.emptyList(), rules, parentPath, currentRule, fieldTypeMap);
        KiePMMLCompoundPredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromCompoundPredicate((Object)result, true);
        int expectedRules = predicates.size() * 2 + 1;
        Assertions.assertThat(rules).hasSize(expectedRules);
        String agendaActivationGroup = String.format("%s_surrogate", currentRule);
        for (KiePMMLDroolsRule retrieved : rules) {
            String ruleName = retrieved.getName();
            if (ruleName.contains("_surrogate_")) {
                String[] ruleNameParts = ruleName.split("_surrogate_");
                String generatedTypePart = ruleNameParts[1];
                boolean isTrueRule = generatedTypePart.endsWith("_TRUE");
                String generatedType = generatedTypePart.replace("_TRUE", "").replace("_FALSE", "");
                Optional<String> fieldName = fieldTypeMap.entrySet().stream().filter(entry -> generatedType.equals(((KiePMMLOriginalTypeGeneratedType)entry.getValue()).getGeneratedType())).map(Map.Entry::getKey).findFirst();
                if (!fieldName.isPresent()) continue;
                SimplePredicate mappedPredicate = predicates.stream().filter(pred -> ((String)fieldName.get()).equals(pred.getField())).findFirst().orElse(null);
                Assertions.assertThat((Object)mappedPredicate).isNotNull();
                Assertions.assertThat((String)retrieved.getStatusConstraint()).isNull();
                Assertions.assertThat((String)retrieved.getActivationGroup()).isEqualTo(agendaActivationGroup);
                Assertions.assertThat((String)retrieved.getAgendaGroup()).isEqualTo(agendaActivationGroup);
                if (isTrueRule) {
                    Assertions.assertThat((String)retrieved.getStatusToSet()).isEqualTo("DONE");
                    Assertions.assertThat((Object)retrieved.getResult()).isEqualTo((Object)result);
                    Assertions.assertThat((Comparable)retrieved.getResultCode()).isEqualTo((Object)ResultCode.OK);
                    continue;
                }
                Assertions.assertThat((String)retrieved.getStatusToSet()).isEqualTo(parentPath);
                Assertions.assertThat((Object)retrieved.getResult()).isNull();
                Assertions.assertThat((Comparable)retrieved.getResultCode()).isNull();
                continue;
            }
            Assertions.assertThat((String)retrieved.getStatusConstraint()).isNotNull();
            Assertions.assertThat((String)retrieved.getStatusConstraint()).isEqualTo(String.format("status == \"%s\"", parentPath));
            Assertions.assertThat((String)retrieved.getFocusedAgendaGroup()).isEqualTo(agendaActivationGroup);
            Assertions.assertThat((String)retrieved.getStatusToSet()).isNull();
            Assertions.assertThat((Object)retrieved.getResult()).isNull();
            Assertions.assertThat((Comparable)retrieved.getResultCode()).isNull();
        }
    }

    @Test
    void declareRuleFromCompoundPredicateSurrogateNotFinalLeaf() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        List<SimplePredicate> predicates = this.getSimplePredicates(fieldTypeMap);
        String parentPath = "_will play";
        String currentRule = "_will play_will play";
        String result = "RESULT";
        CompoundPredicate compoundPredicate = new CompoundPredicate();
        compoundPredicate.setBooleanOperator(CompoundPredicate.BooleanOperator.SURROGATE);
        predicates.forEach(xva$0 -> compoundPredicate.addPredicates(new Predicate[]{xva$0}));
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        PredicateASTFactoryData predicateASTFactoryData = KiePMMLASTTestUtils.getPredicateASTFactoryData((Predicate)compoundPredicate, Collections.emptyList(), rules, parentPath, currentRule, fieldTypeMap);
        KiePMMLCompoundPredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromCompoundPredicate((Object)result, false);
        int expectedRules = predicates.size() * 2 + 1;
        Assertions.assertThat(rules).hasSize(expectedRules);
        String agendaActivationGroup = String.format("%s_surrogate", currentRule);
        for (KiePMMLDroolsRule retrieved : rules) {
            String ruleName = retrieved.getName();
            if (ruleName.contains("_surrogate_")) {
                String[] ruleNameParts = ruleName.split("_surrogate_");
                String generatedTypePart = ruleNameParts[1];
                boolean isTrueRule = generatedTypePart.endsWith("_TRUE");
                String generatedType = generatedTypePart.replace("_TRUE", "").replace("_FALSE", "");
                Optional<String> fieldName = fieldTypeMap.entrySet().stream().filter(entry -> generatedType.equals(((KiePMMLOriginalTypeGeneratedType)entry.getValue()).getGeneratedType())).map(Map.Entry::getKey).findFirst();
                if (!fieldName.isPresent()) continue;
                SimplePredicate mappedPredicate = predicates.stream().filter(pred -> ((String)fieldName.get()).equals(pred.getField())).findFirst().orElse(null);
                Assertions.assertThat((Object)mappedPredicate).isNotNull();
                Assertions.assertThat((String)retrieved.getStatusConstraint()).isNull();
                Assertions.assertThat((String)retrieved.getActivationGroup()).isEqualTo(agendaActivationGroup);
                Assertions.assertThat((String)retrieved.getAgendaGroup()).isEqualTo(agendaActivationGroup);
                if (isTrueRule) {
                    Assertions.assertThat((String)retrieved.getStatusToSet()).isEqualTo(currentRule);
                    Assertions.assertThat((Object)retrieved.getResult()).isNull();
                    Assertions.assertThat((Comparable)retrieved.getResultCode()).isNull();
                    continue;
                }
                Assertions.assertThat((String)retrieved.getStatusToSet()).isEqualTo(parentPath);
                Assertions.assertThat((Object)retrieved.getResult()).isNull();
                Assertions.assertThat((Comparable)retrieved.getResultCode()).isNull();
                continue;
            }
            Assertions.assertThat((String)retrieved.getStatusConstraint()).isNotNull();
            Assertions.assertThat((String)retrieved.getStatusConstraint()).isEqualTo(String.format("status == \"%s\"", parentPath));
            Assertions.assertThat((String)retrieved.getFocusedAgendaGroup()).isEqualTo(agendaActivationGroup);
            Assertions.assertThat((String)retrieved.getStatusToSet()).isNull();
            Assertions.assertThat((Object)retrieved.getResult()).isNull();
            Assertions.assertThat((Comparable)retrieved.getResultCode()).isNull();
        }
    }

    private List<SimplePredicate> getSimplePredicates(Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        return IntStream.range(0, 2).mapToObj(index -> {
            String predicateName = "SIMPLEPREDICATE-" + index;
            fieldTypeMap.put(predicateName, new KiePMMLOriginalTypeGeneratedType(DataType.STRING.value(), KiePMMLModelUtils.getSanitizedClassName((String)predicateName.toUpperCase())));
            return PMMLModelTestUtils.getSimplePredicate((String)predicateName, (Object)("VALUE-" + index), (SimplePredicate.Operator)SimplePredicate.Operator.LESS_THAN);
        }).collect(Collectors.toList());
    }
}

