/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.regression.compiler.factories;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.validator.ProblemReporter;
import com.github.javaparser.ast.validator.language_level_validations.Java8Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.dmg.pmml.regression.CategoricalPredictor;
import org.dmg.pmml.regression.NumericPredictor;
import org.dmg.pmml.regression.PredictorTerm;
import org.dmg.pmml.regression.RegressionTable;
import org.junit.Assert;
import org.kie.pmml.compiler.api.testutils.PMMLModelTestUtils;

public abstract class AbstractKiePMMLRegressionTableRegressionFactoryTest {
    protected RegressionTable regressionTable;
    protected List<CategoricalPredictor> categoricalPredictors;
    protected List<NumericPredictor> numericPredictors;
    protected List<PredictorTerm> predictorTerms;

    protected void commonValidateKiePMMLRegressionTable(String retrieved) {
        try {
            CompilationUnit parsed = StaticJavaParser.parse((String)retrieved);
            Java8Validator validator = new Java8Validator();
            ProblemReporter problemReporter = new ProblemReporter(problem -> Assert.fail((String)problem.getMessage()));
            validator.accept(parsed.findRootNode(), problemReporter);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to validate " + retrieved + " due to " + e.getMessage()));
        }
    }

    protected RegressionTable getRegressionTable(double intercept, Object targetCategory) {
        this.categoricalPredictors = new ArrayList<CategoricalPredictor>();
        this.numericPredictors = new ArrayList<NumericPredictor>();
        this.predictorTerms = new ArrayList<PredictorTerm>();
        this.numericPredictors.add(PMMLModelTestUtils.getNumericPredictor((String)"NumPred-3", (int)1, (double)32.55));
        IntStream.range(0, 3).forEach(i -> {
            IntStream.range(0, 2).forEach(j -> this.categoricalPredictors.add(PMMLModelTestUtils.getCategoricalPredictor((String)("CatPred-" + i), (double)27.12, (double)3.46)));
            this.numericPredictors.add(PMMLModelTestUtils.getNumericPredictor((String)("NumPred-" + i), (int)2, (double)13.11));
            this.predictorTerms.add(PMMLModelTestUtils.getPredictorTerm((String)("PredTerm-" + i), (double)32.29, Arrays.asList(this.categoricalPredictors.get(0).getName().getValue(), this.numericPredictors.get(0).getName().getValue())));
        });
        return PMMLModelTestUtils.getRegressionTable(this.categoricalPredictors, this.numericPredictors, this.predictorTerms, (double)intercept, (Object)targetCategory);
    }
}

