/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.regression.compiler.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import junit.framework.TestCase;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.regression.CategoricalPredictor;
import org.dmg.pmml.regression.NumericPredictor;
import org.dmg.pmml.regression.PredictorTerm;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.api.enums.RESULT_FEATURE;
import org.kie.pmml.api.iinterfaces.SerializableFunction;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.api.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.commons.mocks.HasClassLoaderMock;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.regression.compiler.dto.RegressionCompilationDTO;
import org.kie.pmml.models.regression.compiler.factories.AbstractKiePMMLRegressionTableRegressionFactoryTest;
import org.kie.pmml.models.regression.compiler.factories.KiePMMLRegressionTableFactory;
import org.kie.pmml.models.regression.model.KiePMMLRegressionTable;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLRegressionTableFactoryTest
extends AbstractKiePMMLRegressionTableRegressionFactoryTest {
    private static final String PACKAGE_NAME = "packagename";
    private static final String TEST_01_SOURCE = "KiePMMLRegressionTableFactoryTest_01.txt";
    private static final String TEST_02_SOURCE = "KiePMMLRegressionTableFactoryTest_02.txt";
    private static final String TEST_03_SOURCE = "KiePMMLRegressionTableFactoryTest_03.txt";
    private static final String TEST_04_SOURCE = "KiePMMLRegressionTableFactoryTest_04.txt";
    private static final String TEST_05_SOURCE = "KiePMMLRegressionTableFactoryTest_05.txt";
    private static final String TEST_06_SOURCE = "KiePMMLRegressionTableFactoryTest_06.txt";
    private static final String TEST_07_SOURCE = "KiePMMLRegressionTableFactoryTest_07.txt";
    private static CompilationUnit COMPILATION_UNIT;
    private static ClassOrInterfaceDeclaration MODEL_TEMPLATE;
    private static MethodDeclaration STATIC_GETTER_METHOD;

    @BeforeClass
    public static void setup() {
        COMPILATION_UNIT = JavaParserUtils.getFromFileName((String)"KiePMMLRegressionTableTemplate.tmpl");
        MODEL_TEMPLATE = (ClassOrInterfaceDeclaration)COMPILATION_UNIT.getClassByName("KiePMMLRegressionTableTemplate").get();
        STATIC_GETTER_METHOD = (MethodDeclaration)MODEL_TEMPLATE.getMethodsByName("getKiePMMLTable").get(0);
    }

    @Test
    public void getRegressionTables() {
        this.regressionTable = this.getRegressionTable(3.5, "professional");
        RegressionTable regressionTable2 = this.getRegressionTable(3.9, "hobby");
        RegressionModel regressionModel = new RegressionModel();
        regressionModel.setNormalizationMethod(RegressionModel.NormalizationMethod.CAUCHIT);
        regressionModel.addRegressionTables(new RegressionTable[]{this.regressionTable, regressionTable2});
        regressionModel.setModelName(KiePMMLModelUtils.getGeneratedClassName((String)"RegressionModel"));
        String targetField = "targetField";
        DataField dataField = new DataField();
        dataField.setName(FieldName.create((String)targetField));
        dataField.setOpType(OpType.CATEGORICAL);
        DataDictionary dataDictionary = new DataDictionary();
        dataDictionary.addDataFields(new DataField[]{dataField});
        MiningField miningField = new MiningField();
        miningField.setUsageType(MiningField.UsageType.TARGET);
        miningField.setName(dataField.getName());
        MiningSchema miningSchema = new MiningSchema();
        miningSchema.addMiningFields(new MiningField[]{miningField});
        regressionModel.setMiningSchema(miningSchema);
        PMML pmml = new PMML();
        pmml.setDataDictionary(dataDictionary);
        pmml.addModels(new Model[]{regressionModel});
        CommonCompilationDTO source = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)PACKAGE_NAME, (PMML)pmml, (Model)regressionModel, (HasClassLoader)new HasClassLoaderMock());
        RegressionCompilationDTO compilationDTO = RegressionCompilationDTO.fromCompilationDTORegressionTablesAndNormalizationMethod((CompilationDTO)source, (List)regressionModel.getRegressionTables(), (RegressionModel.NormalizationMethod)regressionModel.getNormalizationMethod());
        LinkedHashMap retrieved = KiePMMLRegressionTableFactory.getRegressionTables((RegressionCompilationDTO)compilationDTO);
        TestCase.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)regressionModel.getRegressionTables().size(), (long)retrieved.size());
        regressionModel.getRegressionTables().forEach(regrTabl -> {
            Assert.assertTrue((boolean)retrieved.containsKey(regrTabl.getTargetCategory().toString()));
            this.commonEvaluateRegressionTable((KiePMMLRegressionTable)retrieved.get(regrTabl.getTargetCategory().toString()), (RegressionTable)regrTabl);
        });
    }

    @Test
    public void getRegressionTable() {
        this.regressionTable = this.getRegressionTable(3.5, "professional");
        RegressionModel regressionModel = new RegressionModel();
        regressionModel.setNormalizationMethod(RegressionModel.NormalizationMethod.CAUCHIT);
        regressionModel.addRegressionTables(new RegressionTable[]{this.regressionTable});
        regressionModel.setModelName(KiePMMLModelUtils.getGeneratedClassName((String)"RegressionModel"));
        String targetField = "targetField";
        DataField dataField = new DataField();
        dataField.setName(FieldName.create((String)targetField));
        dataField.setOpType(OpType.CATEGORICAL);
        DataDictionary dataDictionary = new DataDictionary();
        dataDictionary.addDataFields(new DataField[]{dataField});
        MiningField miningField = new MiningField();
        miningField.setUsageType(MiningField.UsageType.TARGET);
        miningField.setName(dataField.getName());
        MiningSchema miningSchema = new MiningSchema();
        miningSchema.addMiningFields(new MiningField[]{miningField});
        regressionModel.setMiningSchema(miningSchema);
        PMML pmml = new PMML();
        pmml.setDataDictionary(dataDictionary);
        pmml.addModels(new Model[]{regressionModel});
        CommonCompilationDTO source = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)PACKAGE_NAME, (PMML)pmml, (Model)regressionModel, (HasClassLoader)new HasClassLoaderMock());
        RegressionCompilationDTO compilationDTO = RegressionCompilationDTO.fromCompilationDTORegressionTablesAndNormalizationMethod((CompilationDTO)source, new ArrayList(), (RegressionModel.NormalizationMethod)regressionModel.getNormalizationMethod());
        KiePMMLRegressionTable retrieved = KiePMMLRegressionTableFactory.getRegressionTable((RegressionTable)this.regressionTable, (RegressionCompilationDTO)compilationDTO);
        TestCase.assertNotNull((Object)retrieved);
        this.commonEvaluateRegressionTable(retrieved, this.regressionTable);
    }

    @Test
    public void getRegressionTableBuilders() {
        this.regressionTable = this.getRegressionTable(3.5, "professional");
        RegressionModel regressionModel = new RegressionModel();
        regressionModel.setNormalizationMethod(RegressionModel.NormalizationMethod.CAUCHIT);
        regressionModel.addRegressionTables(new RegressionTable[]{this.regressionTable});
        regressionModel.setModelName(KiePMMLModelUtils.getGeneratedClassName((String)"RegressionModel"));
        String targetField = "targetField";
        DataField dataField = new DataField();
        dataField.setName(FieldName.create((String)targetField));
        dataField.setOpType(OpType.CATEGORICAL);
        DataDictionary dataDictionary = new DataDictionary();
        dataDictionary.addDataFields(new DataField[]{dataField});
        MiningField miningField = new MiningField();
        miningField.setUsageType(MiningField.UsageType.TARGET);
        miningField.setName(dataField.getName());
        MiningSchema miningSchema = new MiningSchema();
        miningSchema.addMiningFields(new MiningField[]{miningField});
        regressionModel.setMiningSchema(miningSchema);
        PMML pmml = new PMML();
        pmml.setDataDictionary(dataDictionary);
        pmml.addModels(new Model[]{regressionModel});
        CommonCompilationDTO source = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)PACKAGE_NAME, (PMML)pmml, (Model)regressionModel, (HasClassLoader)new HasClassLoaderMock());
        RegressionCompilationDTO compilationDTO = RegressionCompilationDTO.fromCompilationDTORegressionTablesAndNormalizationMethod((CompilationDTO)source, new ArrayList(), (RegressionModel.NormalizationMethod)regressionModel.getNormalizationMethod());
        LinkedHashMap retrieved = KiePMMLRegressionTableFactory.getRegressionTableBuilders((RegressionCompilationDTO)compilationDTO);
        TestCase.assertNotNull((Object)retrieved);
        retrieved.values().forEach(kiePMMLTableSourceCategory -> this.commonValidateKiePMMLRegressionTable(kiePMMLTableSourceCategory.getSource()));
    }

    @Test
    public void getRegressionTableBuilder() {
        this.regressionTable = this.getRegressionTable(3.5, "professional");
        RegressionModel regressionModel = new RegressionModel();
        regressionModel.setNormalizationMethod(RegressionModel.NormalizationMethod.CAUCHIT);
        regressionModel.addRegressionTables(new RegressionTable[]{this.regressionTable});
        regressionModel.setModelName(KiePMMLModelUtils.getGeneratedClassName((String)"RegressionModel"));
        String targetField = "targetField";
        DataField dataField = new DataField();
        dataField.setName(FieldName.create((String)targetField));
        dataField.setOpType(OpType.CATEGORICAL);
        DataDictionary dataDictionary = new DataDictionary();
        dataDictionary.addDataFields(new DataField[]{dataField});
        MiningField miningField = new MiningField();
        miningField.setUsageType(MiningField.UsageType.TARGET);
        miningField.setName(dataField.getName());
        MiningSchema miningSchema = new MiningSchema();
        miningSchema.addMiningFields(new MiningField[]{miningField});
        regressionModel.setMiningSchema(miningSchema);
        PMML pmml = new PMML();
        pmml.setDataDictionary(dataDictionary);
        pmml.addModels(new Model[]{regressionModel});
        CommonCompilationDTO source = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)PACKAGE_NAME, (PMML)pmml, (Model)regressionModel, (HasClassLoader)new HasClassLoaderMock());
        RegressionCompilationDTO compilationDTO = RegressionCompilationDTO.fromCompilationDTORegressionTablesAndNormalizationMethod((CompilationDTO)source, new ArrayList(), (RegressionModel.NormalizationMethod)regressionModel.getNormalizationMethod());
        Map.Entry retrieved = KiePMMLRegressionTableFactory.getRegressionTableBuilder((RegressionTable)this.regressionTable, (RegressionCompilationDTO)compilationDTO);
        TestCase.assertNotNull((Object)retrieved);
        HashMap<String, String> sources = new HashMap<String, String>();
        sources.put((String)retrieved.getKey(), (String)retrieved.getValue());
        CodegenTestUtils.commonValidateCompilation(sources);
    }

    @Test
    public void getNumericPredictorsMap() {
        List numericPredictors = IntStream.range(0, 3).mapToObj(index -> {
            String predictorName = "predictorName-" + index;
            double coefficient = 1.23 * (double)index;
            return PMMLModelTestUtils.getNumericPredictor((String)predictorName, (int)index, (double)coefficient);
        }).collect(Collectors.toList());
        Map retrieved = KiePMMLRegressionTableFactory.getNumericPredictorsMap(numericPredictors);
        Assert.assertEquals((long)numericPredictors.size(), (long)retrieved.size());
    }

    @Test
    public void getNumericPredictorEntryWithExponent() {
        String predictorName = "predictorName";
        int exponent = 2;
        double coefficient = 1.23;
        NumericPredictor numericPredictor = PMMLModelTestUtils.getNumericPredictor((String)predictorName, (int)exponent, (double)coefficient);
        SerializableFunction retrieved = KiePMMLRegressionTableFactory.getNumericPredictorEntry((NumericPredictor)numericPredictor);
        TestCase.assertNotNull((Object)retrieved);
    }

    @Test
    public void getNumericPredictorEntryWithoutExponent() {
        String predictorName = "predictorName";
        int exponent = 1;
        double coefficient = 1.23;
        NumericPredictor numericPredictor = PMMLModelTestUtils.getNumericPredictor((String)predictorName, (int)exponent, (double)coefficient);
        SerializableFunction retrieved = KiePMMLRegressionTableFactory.getNumericPredictorEntry((NumericPredictor)numericPredictor);
        TestCase.assertNotNull((Object)retrieved);
    }

    @Test
    public void getCategoricalPredictorsMap() {
        List categoricalPredictors = IntStream.range(0, 3).mapToObj(index -> IntStream.range(0, 3).mapToObj(i -> {
            String predictorName = "predictorName-" + index;
            double coefficient = 1.23 * (double)i;
            return PMMLModelTestUtils.getCategoricalPredictor((String)predictorName, (double)i, (double)coefficient);
        }).collect(Collectors.toList())).reduce((categoricalPredictors1, categoricalPredictors2) -> {
            ArrayList toReturn = new ArrayList();
            toReturn.addAll(categoricalPredictors1);
            toReturn.addAll(categoricalPredictors2);
            return toReturn;
        }).get();
        Map retrieved = KiePMMLRegressionTableFactory.getCategoricalPredictorsMap((List)categoricalPredictors);
        Map<String, List<CategoricalPredictor>> groupedCollectors = categoricalPredictors.stream().collect(Collectors.groupingBy(categoricalPredictor -> categoricalPredictor.getField().getValue()));
        Assert.assertEquals((long)groupedCollectors.size(), (long)retrieved.size());
        groupedCollectors.keySet().forEach(predictName -> Assert.assertTrue((boolean)retrieved.containsKey(predictName)));
    }

    @Test
    public void getGroupedCategoricalPredictorMap() {
        ArrayList<CategoricalPredictor> categoricalPredictors = new ArrayList<CategoricalPredictor>();
        for (int i = 0; i < 3; ++i) {
            String predictorName = "predictorName-" + i;
            double coefficient = 1.23 * (double)i;
            categoricalPredictors.add(PMMLModelTestUtils.getCategoricalPredictor((String)predictorName, (double)i, (double)coefficient));
        }
        Map retrieved = KiePMMLRegressionTableFactory.getGroupedCategoricalPredictorMap(categoricalPredictors);
        TestCase.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)categoricalPredictors.size(), (long)retrieved.size());
        categoricalPredictors.forEach(categoricalPredictor -> {
            String key = categoricalPredictor.getValue().toString();
            Assert.assertTrue((boolean)retrieved.containsKey(key));
            Assert.assertEquals((double)categoricalPredictor.getCoefficient().doubleValue(), (double)((Double)retrieved.get(key)), (double)0.0);
        });
    }

    @Test
    public void getPredictorTermsMap() {
        List predictorTerms = IntStream.range(0, 3).mapToObj(index -> {
            String predictorName = "predictorName-" + index;
            double coefficient = 1.23 * (double)index;
            String fieldRef = "fieldRef-" + index;
            return PMMLModelTestUtils.getPredictorTerm((String)predictorName, (double)coefficient, Collections.singletonList(fieldRef));
        }).collect(Collectors.toList());
        Map retrieved = KiePMMLRegressionTableFactory.getPredictorTermsMap(predictorTerms);
        Assert.assertEquals((long)predictorTerms.size(), (long)retrieved.size());
        IntStream.range(0, predictorTerms.size()).forEach(index -> {
            PredictorTerm predictorTerm = (PredictorTerm)predictorTerms.get(index);
            Assert.assertTrue((boolean)retrieved.containsKey(predictorTerm.getName().getValue()));
        });
    }

    @Test
    public void getPredictorTermSerializableFunction() {
        String predictorName = "predictorName";
        double coefficient = 23.12;
        String fieldRef = "fieldRef";
        PredictorTerm predictorTerm = PMMLModelTestUtils.getPredictorTerm((String)predictorName, (double)coefficient, Collections.singletonList(fieldRef));
        SerializableFunction retrieved = KiePMMLRegressionTableFactory.getPredictorTermSerializableFunction((PredictorTerm)predictorTerm);
        TestCase.assertNotNull((Object)retrieved);
    }

    @Test
    public void getResultUpdaterUnsupportedFunction() {
        KiePMMLRegressionTableFactory.UNSUPPORTED_NORMALIZATION_METHODS.forEach(normalizationMethod -> Assert.assertNull((Object)KiePMMLRegressionTableFactory.getResultUpdaterFunction((RegressionModel.NormalizationMethod)normalizationMethod)));
    }

    @Test
    public void getResultUpdaterSupportedFunction() {
        KiePMMLRegressionTableFactory.SUPPORTED_NORMALIZATION_METHODS.forEach(normalizationMethod -> TestCase.assertNotNull((Object)KiePMMLRegressionTableFactory.getResultUpdaterFunction((RegressionModel.NormalizationMethod)normalizationMethod)));
    }

    @Test
    public void setStaticGetter() throws IOException {
        this.regressionTable = this.getRegressionTable(3.5, "professional");
        RegressionModel regressionModel = new RegressionModel();
        regressionModel.setNormalizationMethod(RegressionModel.NormalizationMethod.CAUCHIT);
        regressionModel.addRegressionTables(new RegressionTable[]{this.regressionTable});
        regressionModel.setModelName(KiePMMLModelUtils.getGeneratedClassName((String)"RegressionModel"));
        String targetField = "targetField";
        DataField dataField = new DataField();
        dataField.setName(FieldName.create((String)targetField));
        dataField.setOpType(OpType.CATEGORICAL);
        DataDictionary dataDictionary = new DataDictionary();
        dataDictionary.addDataFields(new DataField[]{dataField});
        MiningField miningField = new MiningField();
        miningField.setUsageType(MiningField.UsageType.TARGET);
        miningField.setName(dataField.getName());
        MiningSchema miningSchema = new MiningSchema();
        miningSchema.addMiningFields(new MiningField[]{miningField});
        regressionModel.setMiningSchema(miningSchema);
        PMML pmml = new PMML();
        pmml.setDataDictionary(dataDictionary);
        pmml.addModels(new Model[]{regressionModel});
        String variableName = "variableName";
        CommonCompilationDTO source = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)PACKAGE_NAME, (PMML)pmml, (Model)regressionModel, (HasClassLoader)new HasClassLoaderMock());
        RegressionCompilationDTO compilationDTO = RegressionCompilationDTO.fromCompilationDTORegressionTablesAndNormalizationMethod((CompilationDTO)source, new ArrayList(), (RegressionModel.NormalizationMethod)regressionModel.getNormalizationMethod());
        MethodDeclaration staticGetterMethod = STATIC_GETTER_METHOD.clone();
        KiePMMLRegressionTableFactory.setStaticGetter((RegressionTable)this.regressionTable, (RegressionCompilationDTO)compilationDTO, (MethodDeclaration)staticGetterMethod, (String)variableName);
        String text = FileUtils.getFileContent((String)TEST_06_SOURCE);
        MethodDeclaration expected = JavaParserUtils.parseMethod((String)text);
        Assert.assertEquals((Object)expected.toString(), (Object)staticGetterMethod.toString());
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)staticGetterMethod));
        List<Class> imports = Arrays.asList(AtomicReference.class, Collections.class, Arrays.class, List.class, Map.class, KiePMMLRegressionTable.class, SerializableFunction.class);
        CodegenTestUtils.commonValidateCompilationWithImports((MethodDeclaration)staticGetterMethod, imports);
    }

    @Test
    public void getResultUpdaterExpressionWithSupportedMethods() {
        KiePMMLRegressionTableFactory.SUPPORTED_NORMALIZATION_METHODS.forEach(normalizationMethod -> {
            Expression retrieved = KiePMMLRegressionTableFactory.getResultUpdaterExpression((RegressionModel.NormalizationMethod)normalizationMethod);
            try {
                String text = FileUtils.getFileContent((String)TEST_03_SOURCE);
                Expression expected = JavaParserUtils.parseExpression((String)String.format(text, normalizationMethod.name()));
                Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        });
    }

    @Test
    public void getResultUpdaterExpression() {
        KiePMMLRegressionTableFactory.UNSUPPORTED_NORMALIZATION_METHODS.forEach(normalizationMethod -> {
            Expression retrieved = KiePMMLRegressionTableFactory.getResultUpdaterExpression((RegressionModel.NormalizationMethod)normalizationMethod);
            Assert.assertTrue((boolean)(retrieved instanceof NullLiteralExpr));
        });
    }

    @Test
    public void getResultUpdaterSupportedExpression() throws IOException {
        MethodReferenceExpr retrieved = KiePMMLRegressionTableFactory.getResultUpdaterSupportedExpression((RegressionModel.NormalizationMethod)RegressionModel.NormalizationMethod.CAUCHIT);
        String text = FileUtils.getFileContent((String)TEST_03_SOURCE);
        Expression expected = JavaParserUtils.parseExpression((String)String.format(text, RegressionModel.NormalizationMethod.CAUCHIT.name()));
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
    }

    @Test
    public void getNumericPredictorsExpressions() {
        List numericPredictors = IntStream.range(0, 3).mapToObj(index -> {
            String predictorName = "predictorName-" + index;
            double coefficient = 1.23 * (double)index;
            return PMMLModelTestUtils.getNumericPredictor((String)predictorName, (int)index, (double)coefficient);
        }).collect(Collectors.toList());
        Map retrieved = KiePMMLRegressionTableFactory.getNumericPredictorsExpressions(numericPredictors);
        Assert.assertEquals((long)numericPredictors.size(), (long)retrieved.size());
    }

    @Test
    public void getNumericPredictorExpressionWithExponent() throws IOException {
        String predictorName = "predictorName";
        int exponent = 2;
        double coefficient = 1.23;
        NumericPredictor numericPredictor = PMMLModelTestUtils.getNumericPredictor((String)predictorName, (int)exponent, (double)coefficient);
        CastExpr retrieved = KiePMMLRegressionTableFactory.getNumericPredictorExpression((NumericPredictor)numericPredictor);
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        Expression expected = JavaParserUtils.parseExpression((String)String.format(text, coefficient, exponent));
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
    }

    @Test
    public void getNumericPredictorExpressionWithoutExponent() throws IOException {
        String predictorName = "predictorName";
        int exponent = 1;
        double coefficient = 1.23;
        NumericPredictor numericPredictor = PMMLModelTestUtils.getNumericPredictor((String)predictorName, (int)exponent, (double)coefficient);
        CastExpr retrieved = KiePMMLRegressionTableFactory.getNumericPredictorExpression((NumericPredictor)numericPredictor);
        String text = FileUtils.getFileContent((String)TEST_02_SOURCE);
        Expression expected = JavaParserUtils.parseExpression((String)String.format(text, coefficient));
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
    }

    @Test
    public void getCategoricalPredictorsExpressions() {
        List categoricalPredictors = IntStream.range(0, 3).mapToObj(index -> IntStream.range(0, 3).mapToObj(i -> {
            String predictorName = "predictorName-" + index;
            double coefficient = 1.23 * (double)i;
            return PMMLModelTestUtils.getCategoricalPredictor((String)predictorName, (double)i, (double)coefficient);
        }).collect(Collectors.toList())).reduce((categoricalPredictors1, categoricalPredictors2) -> {
            ArrayList toReturn = new ArrayList();
            toReturn.addAll(categoricalPredictors1);
            toReturn.addAll(categoricalPredictors2);
            return toReturn;
        }).get();
        BlockStmt body = new BlockStmt();
        Map retrieved = KiePMMLRegressionTableFactory.getCategoricalPredictorsExpressions((List)categoricalPredictors, (BlockStmt)body, (String)"variableName");
        Assert.assertEquals((long)3L, (long)retrieved.size());
        Map<String, List<CategoricalPredictor>> groupedCollectors = categoricalPredictors.stream().collect(Collectors.groupingBy(categoricalPredictor -> categoricalPredictor.getField().getValue()));
        groupedCollectors.values().forEach(categoricalPredictors12 -> this.commonEvaluateCategoryPredictors(body, (List<CategoricalPredictor>)categoricalPredictors12, "variableName"));
    }

    @Test
    public void populateWithGroupedCategoricalPredictorMap() throws IOException {
        ArrayList<CategoricalPredictor> categoricalPredictors = new ArrayList<CategoricalPredictor>();
        for (int i = 0; i < 3; ++i) {
            String predictorName = "predictorName-" + i;
            double coefficient = 1.23 * (double)i;
            categoricalPredictors.add(PMMLModelTestUtils.getCategoricalPredictor((String)predictorName, (double)i, (double)coefficient));
        }
        BlockStmt toPopulate = new BlockStmt();
        String categoricalPredictorMapName = "categoricalPredictorMapName";
        KiePMMLRegressionTableFactory.populateWithGroupedCategoricalPredictorMap(categoricalPredictors, (BlockStmt)toPopulate, (String)"categoricalPredictorMapName");
        String text = FileUtils.getFileContent((String)TEST_04_SOURCE);
        BlockStmt expected = JavaParserUtils.parseBlock((String)String.format(text, "categoricalPredictorMapName", ((CategoricalPredictor)categoricalPredictors.get(0)).getValue(), ((CategoricalPredictor)categoricalPredictors.get(0)).getCoefficient(), ((CategoricalPredictor)categoricalPredictors.get(1)).getValue(), ((CategoricalPredictor)categoricalPredictors.get(1)).getCoefficient(), ((CategoricalPredictor)categoricalPredictors.get(2)).getValue(), ((CategoricalPredictor)categoricalPredictors.get(2)).getCoefficient()));
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)toPopulate));
    }

    @Test
    public void getCategoricalPredictorExpression() throws IOException {
        String categoricalPredictorMapName = "categoricalPredictorMapName";
        CastExpr retrieved = KiePMMLRegressionTableFactory.getCategoricalPredictorExpression((String)"categoricalPredictorMapName");
        String text = FileUtils.getFileContent((String)TEST_05_SOURCE);
        Expression expected = JavaParserUtils.parseExpression((String)String.format(text, "categoricalPredictorMapName"));
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
    }

    @Test
    public void getPredictorTermFunctions() {
        List predictorTerms = IntStream.range(0, 3).mapToObj(index -> {
            String predictorName = "predictorName-" + index;
            double coefficient = 1.23 * (double)index;
            String fieldRef = "fieldRef-" + index;
            return PMMLModelTestUtils.getPredictorTerm((String)predictorName, (double)coefficient, Collections.singletonList(fieldRef));
        }).collect(Collectors.toList());
        Map retrieved = KiePMMLRegressionTableFactory.getPredictorTermFunctions(predictorTerms);
        Assert.assertEquals((long)predictorTerms.size(), (long)retrieved.size());
        IntStream.range(0, predictorTerms.size()).forEach(index -> {
            PredictorTerm predictorTerm = (PredictorTerm)predictorTerms.get(index);
            Assert.assertTrue((boolean)retrieved.containsKey(predictorTerm.getName().getValue()));
        });
    }

    @Test
    public void getPredictorTermFunction() throws IOException {
        String predictorName = "predictorName";
        double coefficient = 23.12;
        String fieldRef = "fieldRef";
        PredictorTerm predictorTerm = PMMLModelTestUtils.getPredictorTerm((String)predictorName, (double)coefficient, Collections.singletonList(fieldRef));
        LambdaExpr retrieved = KiePMMLRegressionTableFactory.getPredictorTermFunction((PredictorTerm)predictorTerm);
        String text = FileUtils.getFileContent((String)TEST_07_SOURCE);
        Expression expected = JavaParserUtils.parseExpression((String)String.format(text, fieldRef, coefficient));
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
    }

    @Test
    public void populateOutputFieldsMap() {
        ArrayList<Object> outputFields = new ArrayList<Object>();
        KiePMMLOutputField predictedOutputField = this.getOutputField("KOF-TARGET", RESULT_FEATURE.PREDICTED_VALUE, "TARGET");
        outputFields.add(predictedOutputField);
        List probabilityOutputFields = IntStream.range(0, 2).mapToObj(index -> this.getOutputField("KOF-PROB-" + index, RESULT_FEATURE.PROBABILITY, "PROB-" + index)).collect(Collectors.toList());
        outputFields.addAll(probabilityOutputFields);
    }

    private void commonEvaluateRegressionTable(KiePMMLRegressionTable retrieved, RegressionTable source) {
        Map numericFunctionMap = retrieved.getNumericFunctionMap();
        Assert.assertEquals((long)source.getNumericPredictors().size(), (long)numericFunctionMap.size());
        source.getNumericPredictors().forEach(numericPredictor -> Assert.assertTrue((boolean)numericFunctionMap.containsKey(numericPredictor.getName().getValue())));
        Map categoricalFunctionMap = retrieved.getCategoricalFunctionMap();
        Map<String, List<CategoricalPredictor>> groupedCollectors = this.categoricalPredictors.stream().collect(Collectors.groupingBy(categoricalPredictor -> categoricalPredictor.getField().getValue()));
        Assert.assertEquals((long)groupedCollectors.size(), (long)categoricalFunctionMap.size());
        groupedCollectors.keySet().forEach(categorical -> Assert.assertTrue((boolean)categoricalFunctionMap.containsKey(categorical)));
        Map predictorTermsFunctionMap = retrieved.getPredictorTermsFunctionMap();
        Assert.assertEquals((long)source.getPredictorTerms().size(), (long)predictorTermsFunctionMap.size());
        source.getPredictorTerms().forEach(predictorTerm -> Assert.assertTrue((boolean)predictorTermsFunctionMap.containsKey(predictorTerm.getName().getValue())));
    }

    private void commonEvaluateCategoryPredictors(BlockStmt toVerify, List<CategoricalPredictor> categoricalPredictors, String variableName) {
        for (int i = 0; i < categoricalPredictors.size(); ++i) {
            CategoricalPredictor categoricalPredictor = categoricalPredictors.get(i);
            String expectedVariableName = KiePMMLModelUtils.getSanitizedVariableName((String)String.format("%sMap", variableName)) + "_" + i;
            Assert.assertTrue((boolean)toVerify.getStatements().stream().anyMatch(statement -> {
                String expected = String.format("%s.put(\"%s\", %s);", expectedVariableName, categoricalPredictor.getValue(), categoricalPredictor.getCoefficient());
                return statement instanceof ExpressionStmt && ((ExpressionStmt)statement).getExpression() instanceof MethodCallExpr && statement.toString().equals(expected);
            }));
        }
    }

    private KiePMMLOutputField getOutputField(String name, RESULT_FEATURE resultFeature, String targetField) {
        return (KiePMMLOutputField)KiePMMLOutputField.builder((String)name, Collections.emptyList()).withResultFeature(resultFeature).withTargetField(targetField).build();
    }
}

