/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.tests;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.drools.util.FileUtils;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.kie.pmml.api.PMMLRuntimeFactory;
import org.kie.pmml.api.models.PMMLStep;
import org.kie.pmml.api.runtime.PMMLListener;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.api.runtime.PMMLRuntimeContext;
import org.kie.pmml.evaluator.core.PMMLRuntimeContextImpl;
import org.kie.pmml.evaluator.core.service.PMMLRuntimeInternalImpl;
import org.kie.pmml.evaluator.core.utils.PMMLRequestDataBuilder;
import org.kie.pmml.evaluator.utils.SPIUtils;

public class AbstractPMMLTest {
    private static final PMMLRuntimeFactory PMML_RUNTIME_FACTORY = SPIUtils.getPMMLRuntimeFactory((boolean)false);

    protected static PMMLRuntime getPMMLRuntime(String fileName) {
        fileName = (String)fileName + ".pmml";
        File pmmlFile = FileUtils.getFile((String)fileName);
        return PMML_RUNTIME_FACTORY.getPMMLRuntimeFromFile(pmmlFile);
    }

    protected static PMMLRequestData getPMMLRequestData(String modelName, Map<String, Object> parameters) {
        String correlationId = "CORRELATION_ID";
        PMMLRequestDataBuilder pmmlRequestDataBuilder = new PMMLRequestDataBuilder(correlationId, modelName);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            Object pValue = entry.getValue();
            Class<?> class1 = pValue.getClass();
            pmmlRequestDataBuilder.addParameter(entry.getKey(), pValue, class1);
        }
        return pmmlRequestDataBuilder.build();
    }

    protected PMML4Result evaluate(PMMLRuntime pmmlRuntime, Map<String, Object> inputData, String fileName, String modelName) {
        return this.evaluate(pmmlRuntime, inputData, fileName, modelName, Collections.emptySet());
    }

    protected PMML4Result evaluate(PMMLRuntime pmmlRuntime, Map<String, Object> inputData, String fileName, String modelName, Set<PMMLListener> pmmlListeners) {
        PMMLRequestData pmmlRequestData = AbstractPMMLTest.getPMMLRequestData(modelName, inputData);
        KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader = new KieMemoryCompiler.MemoryCompilerClassLoader(Thread.currentThread().getContextClassLoader());
        PMMLRuntimeContextImpl context = new PMMLRuntimeContextImpl(pmmlRequestData, fileName, pmmlListeners, memoryCompilerClassLoader);
        context.getGeneratedResourcesMap().putAll(((PMMLRuntimeInternalImpl)pmmlRuntime).getGeneratedResourcesMap());
        return pmmlRuntime.evaluate(modelName, (PMMLRuntimeContext)context);
    }

    protected PMMLListenerTest getPMMLListener() {
        return new PMMLListenerTest();
    }

    protected void commonValidateListeners(Set<PMMLListener> toValidate, List<PMMLStep> expectedSteps) {
        toValidate.forEach(listener -> this.commonValidateListener((PMMLListenerTest)listener, expectedSteps));
    }

    private void commonValidateListener(PMMLListenerTest toValidate, List<PMMLStep> expectedSteps) {
        Assertions.assertThat(toValidate.getSteps()).isEqualTo(expectedSteps);
    }

    protected static class PMMLListenerTest
    implements PMMLListener {
        private List<PMMLStep> steps = new ArrayList<PMMLStep>();

        protected PMMLListenerTest() {
        }

        public List<PMMLStep> getSteps() {
            return this.steps;
        }

        public void stepExecuted(PMMLStep step) {
            this.steps.add(step);
        }
    }
}

