/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.util.GenericType;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;

public class KieServicesClient {
    private final String baseURI;
    private final String username;
    private final String password;

    public KieServicesClient(String baseURI) {
        this.baseURI = baseURI;
        this.username = null;
        this.password = null;
    }

    public KieServicesClient(String baseURI, String username, String password) {
        this.baseURI = baseURI;
        this.username = username;
        this.password = password;
    }

    public ServiceResponse<KieServerInfo> getServerInfo() throws ClientResponseFailure {
        ClientResponse response = null;
        try {
            ClientRequest clientRequest = this.newRequest(this.baseURI);
            response = clientRequest.get((GenericType)new GenericType<ServiceResponse<KieServerInfo>>(){});
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                return (ServiceResponse)response.getEntity();
            }
            throw new ClientResponseFailure("Unexpected response code: " + response.getStatus(), response);
        }
        catch (ClientResponseFailure e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientResponseFailure("Unexpected exception retrieving server info.", (Throwable)e, response);
        }
    }

    private ClientRequest newRequest(String uri) {
        URI uriObject;
        try {
            uriObject = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Malformed URI was specified: '" + uri + "'!", e);
        }
        if (this.username == null || this.password == null) {
            return new ClientRequest(uri);
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(uriObject.getHost(), uriObject.getPort()), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        ApacheHttpClient4Executor executor = new ApacheHttpClient4Executor((HttpClient)client);
        return new ClientRequest(uri, (ClientExecutor)executor);
    }

    public ServiceResponse<KieContainerResourceList> listContainers() throws ClientResponseFailure {
        ClientResponse response = null;
        try {
            ClientRequest clientRequest = this.newRequest(this.baseURI + "/containers");
            response = clientRequest.get((GenericType)new GenericType<ServiceResponse<KieContainerResourceList>>(){});
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                return (ServiceResponse)response.getEntity();
            }
            throw new ClientResponseFailure("Unexpected response code: " + response.getStatus(), response);
        }
        catch (ClientResponseFailure e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientResponseFailure("Unexpected exception retrieving list of containers.", (Throwable)e, response);
        }
    }

    public ServiceResponse<KieContainerResource> createContainer(String id, KieContainerResource resource) throws ClientResponseFailure {
        ClientResponse response = null;
        try {
            ClientRequest clientRequest = this.newRequest(this.baseURI + "/containers/" + id);
            response = clientRequest.body(MediaType.APPLICATION_XML_TYPE, (Object)resource).put((GenericType)new GenericType<ServiceResponse<KieContainerResource>>(){});
            if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
                return (ServiceResponse)response.getEntity();
            }
            if (response.getStatus() == Response.Status.BAD_REQUEST.getStatusCode()) {
                return (ServiceResponse)response.getEntity();
            }
            throw new ClientResponseFailure("Unexpected response code: " + response.getStatus(), response);
        }
        catch (ClientResponseFailure e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientResponseFailure("Unexpected exception creating container: " + id + " with release-id " + resource.getReleaseId(), (Throwable)e, response);
        }
    }

    public ServiceResponse<KieContainerResource> getContainerInfo(String id) throws ClientResponseFailure {
        ClientResponse response = null;
        try {
            ClientRequest clientRequest = this.newRequest(this.baseURI + "/containers/" + id);
            response = clientRequest.get((GenericType)new GenericType<ServiceResponse<KieContainerResource>>(){});
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                return (ServiceResponse)response.getEntity();
            }
            throw new ClientResponseFailure("Unexpected response code: " + response.getStatus(), response);
        }
        catch (ClientResponseFailure e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientResponseFailure("Unexpected exception retrieving container info.", (Throwable)e, response);
        }
    }

    public ServiceResponse<Void> disposeContainer(String id) throws ClientResponseFailure {
        ClientResponse response = null;
        try {
            ClientRequest clientRequest = this.newRequest(this.baseURI + "/containers/" + id);
            response = clientRequest.delete((GenericType)new GenericType<ServiceResponse<Void>>(){});
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                return (ServiceResponse)response.getEntity();
            }
            throw new ClientResponseFailure("Unexpected response code: " + response.getStatus(), response);
        }
        catch (ClientResponseFailure e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientResponseFailure("Unexpected exception disposing container: " + id, (Throwable)e, response);
        }
    }

    public ServiceResponse<String> executeCommands(String id, String payload) throws ClientResponseFailure {
        ClientResponse response = null;
        try {
            ClientRequest clientRequest = this.newRequest(this.baseURI + "/containers/" + id);
            response = clientRequest.body(MediaType.APPLICATION_XML_TYPE, (Object)payload).post((GenericType)new GenericType<ServiceResponse<String>>(){});
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                return (ServiceResponse)response.getEntity();
            }
            throw new ClientResponseFailure("Unexpected response code: " + response.getStatus(), response);
        }
        catch (ClientResponseFailure e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientResponseFailure("Unexpected exception executing commands on container " + id, (Throwable)e, response);
        }
    }

    public List<ServiceResponse<? extends Object>> executeScript(CommandScript script) throws ClientResponseFailure {
        ClientResponse response = null;
        try {
            ClientRequest clientRequest = this.newRequest(this.baseURI);
            response = clientRequest.body(MediaType.APPLICATION_XML_TYPE, (Object)script).post((GenericType)new GenericType<List<ServiceResponse<? extends Object>>>(){});
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                return (List)response.getEntity();
            }
            throw new ClientResponseFailure("Unexpected response code: " + response.getStatus(), response);
        }
        catch (ClientResponseFailure e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientResponseFailure("Unexpected exception retrieving server info.", (Throwable)e, response);
        }
    }

    public ServiceResponse<KieScannerResource> getScannerInfo(String id) {
        ClientResponse response = null;
        try {
            ClientRequest clientRequest = this.newRequest(this.baseURI + "/containers/" + id + "/scanner");
            response = clientRequest.get((GenericType)new GenericType<ServiceResponse<KieScannerResource>>(){});
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                return (ServiceResponse)response.getEntity();
            }
            throw new ClientResponseFailure("Unexpected response code: " + response.getStatus(), response);
        }
        catch (ClientResponseFailure e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientResponseFailure("Unexpected exception retrieving scanner info for container '" + id + "'.", (Throwable)e, response);
        }
    }

    public ServiceResponse<KieScannerResource> updateScanner(String id, KieScannerResource resource) {
        ClientResponse response = null;
        try {
            ClientRequest clientRequest = this.newRequest(this.baseURI + "/containers/" + id + "/scanner");
            response = clientRequest.body(MediaType.APPLICATION_XML_TYPE, (Object)resource).post((GenericType)new GenericType<ServiceResponse<KieScannerResource>>(){});
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                return (ServiceResponse)response.getEntity();
            }
            throw new ClientResponseFailure("Unexpected response code: " + response.getStatus(), response);
        }
        catch (ClientResponseFailure e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientResponseFailure("Unexpected exception scanner for container '" + id + "'.", (Throwable)e, response);
        }
    }

    public ServiceResponse<ReleaseId> updateReleaseId(String id, ReleaseId releaseId) {
        ClientResponse response = null;
        try {
            ClientRequest clientRequest = this.newRequest(this.baseURI + "/containers/" + id + "/release-id");
            response = clientRequest.body(MediaType.APPLICATION_XML_TYPE, (Object)releaseId).post((GenericType)new GenericType<ServiceResponse<ReleaseId>>(){});
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                return (ServiceResponse)response.getEntity();
            }
            throw new ClientResponseFailure("Unexpected response code: " + response.getStatus(), response);
        }
        catch (ClientResponseFailure e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientResponseFailure("Unexpected exception updating releaseId for container '" + id + "'.", (Throwable)e, response);
        }
    }
}

