/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client;

import java.io.IOException;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.introspect.JacksonAnnotationIntrospector;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;
import org.kie.server.client.SerializationException;
import org.kie.server.client.SerializationProvider;

public class JsonSerializationProvider
implements SerializationProvider {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JsonSerializationProvider() {
        JaxbAnnotationIntrospector primary = new JaxbAnnotationIntrospector();
        JacksonAnnotationIntrospector secondary = new JacksonAnnotationIntrospector();
        AnnotationIntrospector.Pair introspectorPair = new AnnotationIntrospector.Pair((AnnotationIntrospector)primary, (AnnotationIntrospector)secondary);
        this.objectMapper.setDeserializationConfig(this.objectMapper.getDeserializationConfig().withAnnotationIntrospector((AnnotationIntrospector)introspectorPair));
        this.objectMapper.setSerializationConfig(this.objectMapper.getSerializationConfig().withAnnotationIntrospector((AnnotationIntrospector)introspectorPair));
    }

    @Override
    public String serialize(Object objectInput) {
        try {
            return this.objectMapper.writeValueAsString(objectInput);
        }
        catch (IOException e) {
            throw new SerializationException("Can't serialize the provided object!", e);
        }
    }

    @Override
    public Object deserialize(String serializedInput) {
        Class type = null;
        return this.deserialize(serializedInput, type);
    }

    @Override
    public <T> T deserialize(String serializedInput, Class<T> type) {
        try {
            return (T)this.objectMapper.readValue(serializedInput, type);
        }
        catch (IOException e) {
            throw new SerializationException("Can't deserialize provided string!", e);
        }
    }
}

