/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client;

import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.naming.InitialContext;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.impl.KieServicesClientImpl;
import org.kie.server.client.impl.KieServicesConfigurationImpl;

public class KieServicesFactory {
    private KieServicesFactory() {
    }

    public static KieServicesConfiguration newRestConfiguration(String serverUrl, String login, String password) {
        return new KieServicesConfigurationImpl(serverUrl, login, password);
    }

    public static KieServicesConfiguration newRestConfiguration(String serverUrl, String login, String password, int timeout) {
        return new KieServicesConfigurationImpl(serverUrl, login, password, timeout);
    }

    public static KieServicesConfiguration newJMSConfiguration(ConnectionFactory connectionFactory, Queue requestQueue, Queue responseQueue) {
        return new KieServicesConfigurationImpl(connectionFactory, requestQueue, responseQueue);
    }

    public static KieServicesConfiguration newJMSConfiguration(ConnectionFactory connectionFactory, Queue requestQueue, Queue responseQueue, String username, String password) {
        return new KieServicesConfigurationImpl(connectionFactory, requestQueue, responseQueue, username, password);
    }

    public static KieServicesConfiguration newJMSConfiguration(InitialContext context, String username, String password) {
        return new KieServicesConfigurationImpl(context, username, password);
    }

    public static KieServicesClient newKieServicesClient(KieServicesConfiguration conf) {
        return new KieServicesClientImpl(conf);
    }

    public static KieServicesClient newKieServicesRestClient(String serverUrl, String login, String password) {
        return new KieServicesClientImpl(KieServicesFactory.newRestConfiguration(serverUrl, login, password));
    }

    public static KieServicesClient newKieServicesJMSClient(ConnectionFactory connectionFactory, Queue requestQueue, Queue responseQueue) {
        return new KieServicesClientImpl(KieServicesFactory.newJMSConfiguration(connectionFactory, requestQueue, responseQueue));
    }

    public static KieServicesClient newKieServicesJMSClient(ConnectionFactory connectionFactory, Queue requestQueue, Queue responseQueue, String username, String password) {
        return new KieServicesClientImpl(KieServicesFactory.newJMSConfiguration(connectionFactory, requestQueue, responseQueue, username, password));
    }

    public static KieServicesClient newKieServicesJMSClient(InitialContext context, String username, String password) {
        return new KieServicesClientImpl(KieServicesFactory.newJMSConfiguration(context, username, password));
    }
}

