/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.UUID;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.ws.rs.core.Response;
import org.kie.remote.common.rest.KieRemoteHttpRequest;
import org.kie.remote.common.rest.KieRemoteHttpResponse;
import org.kie.server.api.commands.CallContainerCommand;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.CreateContainerCommand;
import org.kie.server.api.commands.DisposeContainerCommand;
import org.kie.server.api.commands.GetContainerInfoCommand;
import org.kie.server.api.commands.GetScannerInfoCommand;
import org.kie.server.api.commands.GetServerInfoCommand;
import org.kie.server.api.commands.ListContainersCommand;
import org.kie.server.api.commands.UpdateReleaseIdCommand;
import org.kie.server.api.commands.UpdateScannerCommand;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServicesClientImpl
implements KieServicesClient {
    private static Logger logger = LoggerFactory.getLogger(KieServicesClientImpl.class);
    private String baseURI;
    private final KieServicesConfiguration config;
    private final Marshaller marshaller;

    public KieServicesClientImpl(KieServicesConfiguration config) {
        this.config = config.clone();
        this.baseURI = config.getServerUrl();
        ClassLoader cl = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : CommandScript.class.getClassLoader();
        this.marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)config.getMarshallingFormat(), (ClassLoader)cl);
    }

    private String initializeURI(URL url, String servicePrefix) {
        if (url == null) {
            throw new IllegalArgumentException("The url may not be empty or null.");
        }
        try {
            url.toURI();
        }
        catch (URISyntaxException urise) {
            throw new IllegalArgumentException("URL (" + url.toExternalForm() + ") is incorrectly formatted: " + urise.getMessage(), urise);
        }
        String urlString = url.toExternalForm();
        if (!urlString.endsWith("/")) {
            urlString = urlString + "/";
        }
        urlString = urlString + "services/" + servicePrefix + "/server";
        try {
            URL serverPlusServicePrefixUrl = new URL(urlString);
        }
        catch (MalformedURLException murle) {
            throw new IllegalArgumentException("URL (" + url.toExternalForm() + ") is incorrectly formatted: " + murle.getMessage(), murle);
        }
        return urlString;
    }

    @Override
    public ServiceResponse<KieServerInfo> getServerInfo() {
        if (this.config.isRest()) {
            return this.makeHttpGetRequestAndCreateServiceResponse(this.baseURI, KieServerInfo.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new GetServerInfoCommand()));
        return (ServiceResponse)this.executeJmsCommand(script).getResponses().get(0);
    }

    @Override
    public ServiceResponse<KieContainerResourceList> listContainers() {
        if (this.config.isRest()) {
            return this.makeHttpGetRequestAndCreateServiceResponse(this.baseURI + "/containers", KieContainerResourceList.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new ListContainersCommand()));
        return (ServiceResponse)this.executeJmsCommand(script).getResponses().get(0);
    }

    @Override
    public ServiceResponse<KieContainerResource> createContainer(String id, KieContainerResource resource) {
        if (this.config.isRest()) {
            return this.makeHttpPutRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id, resource, KieContainerResource.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new CreateContainerCommand(resource)));
        return (ServiceResponse)this.executeJmsCommand(script).getResponses().get(0);
    }

    @Override
    public ServiceResponse<KieContainerResource> getContainerInfo(String id) {
        if (this.config.isRest()) {
            return this.makeHttpGetRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id, KieContainerResource.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new GetContainerInfoCommand(id)));
        return (ServiceResponse)this.executeJmsCommand(script).getResponses().get(0);
    }

    @Override
    public ServiceResponse<Void> disposeContainer(String id) {
        if (this.config.isRest()) {
            return this.makeHttpDeleteRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id, Void.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DisposeContainerCommand(id)));
        return (ServiceResponse)this.executeJmsCommand(script).getResponses().get(0);
    }

    @Override
    public ServiceResponse<String> executeCommands(String id, String payload) {
        if (this.config.isRest()) {
            return this.makeHttpPostRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id, payload, String.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new CallContainerCommand(id, payload)));
        return (ServiceResponse)this.executeJmsCommand(script).getResponses().get(0);
    }

    @Override
    public ServiceResponsesList executeScript(CommandScript script) {
        if (this.config.isRest()) {
            return this.makeHttpPostRequestAndCreateCustomResult(this.baseURI, script, ServiceResponsesList.class);
        }
        return this.executeJmsCommand(script);
    }

    @Override
    public ServiceResponse<KieScannerResource> getScannerInfo(String id) {
        if (this.config.isRest()) {
            return this.makeHttpGetRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id + "/scanner", KieScannerResource.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new GetScannerInfoCommand(id)));
        return (ServiceResponse)this.executeJmsCommand(script).getResponses().get(0);
    }

    @Override
    public ServiceResponse<KieScannerResource> updateScanner(String id, KieScannerResource resource) {
        if (this.config.isRest()) {
            return this.makeHttpPostRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id + "/scanner", resource, KieScannerResource.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new UpdateScannerCommand(id, resource)));
        return (ServiceResponse)this.executeJmsCommand(script).getResponses().get(0);
    }

    @Override
    public ServiceResponse<ReleaseId> updateReleaseId(String id, ReleaseId releaseId) {
        if (this.config.isRest()) {
            return this.makeHttpPostRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id + "/release-id", releaseId, ReleaseId.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new UpdateReleaseIdCommand(id, releaseId)));
        return (ServiceResponse)this.executeJmsCommand(script).getResponses().get(0);
    }

    private <T> ServiceResponse<T> makeHttpGetRequestAndCreateServiceResponse(String uri, Class<T> resultType) {
        KieRemoteHttpRequest request = this.newRequest(uri).get();
        KieRemoteHttpResponse response = request.response();
        if (response.code() == Response.Status.OK.getStatusCode()) {
            ServiceResponse serviceResponse = this.deserialize(response.body(), ServiceResponse.class);
            this.checkResultType(serviceResponse, resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    private <T> ServiceResponse<T> makeHttpPostRequestAndCreateServiceResponse(String uri, Object bodyObject, Class<T> resultType) {
        return this.makeHttpPostRequestAndCreateServiceResponse(uri, this.serialize(bodyObject), resultType);
    }

    private <T> ServiceResponse<T> makeHttpPostRequestAndCreateServiceResponse(String uri, String body, Class<T> resultType) {
        KieRemoteHttpRequest request = this.newRequest(uri).body((CharSequence)body).post();
        KieRemoteHttpResponse response = request.response();
        if (response.code() == Response.Status.OK.getStatusCode()) {
            ServiceResponse serviceResponse = this.deserialize(response.body(), ServiceResponse.class);
            this.checkResultType(serviceResponse, resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    private <T> T makeHttpPostRequestAndCreateCustomResult(String uri, Object bodyObject, Class<T> resultType) {
        return this.makeHttpPostRequestAndCreateCustomResult(uri, this.serialize(bodyObject), resultType);
    }

    private <T> T makeHttpPostRequestAndCreateCustomResult(String uri, String body, Class<T> resultType) {
        KieRemoteHttpRequest request = this.newRequest(uri).body((CharSequence)body).post();
        KieRemoteHttpResponse response = request.response();
        if (response.code() == Response.Status.OK.getStatusCode()) {
            return this.deserialize(response.body(), resultType);
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    private <T> ServiceResponse<T> makeHttpPutRequestAndCreateServiceResponse(String uri, Object bodyObject, Class<T> resultType) {
        return this.makeHttpPutRequestAndCreateServiceResponse(uri, this.serialize(bodyObject), resultType);
    }

    private <T> ServiceResponse<T> makeHttpPutRequestAndCreateServiceResponse(String uri, String body, Class<T> resultType) {
        KieRemoteHttpRequest request = this.newRequest(uri).body((CharSequence)body).put();
        KieRemoteHttpResponse response = request.response();
        if (response.code() == Response.Status.CREATED.getStatusCode() || response.code() == Response.Status.BAD_REQUEST.getStatusCode()) {
            ServiceResponse serviceResponse = this.deserialize(response.body(), ServiceResponse.class);
            this.checkResultType(serviceResponse, resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    private <T> ServiceResponse<T> makeHttpDeleteRequestAndCreateServiceResponse(String uri, Class<T> resultType) {
        KieRemoteHttpRequest request = this.newRequest(uri).delete();
        KieRemoteHttpResponse response = request.response();
        if (response.code() == Response.Status.OK.getStatusCode()) {
            ServiceResponse serviceResponse = this.deserialize(response.body(), ServiceResponse.class);
            this.checkResultType(serviceResponse, resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    private KieRemoteHttpRequest newRequest(String uri) {
        KieRemoteHttpRequest httpRequest = KieRemoteHttpRequest.newRequest((String)uri).followRedirects(true).timeout(this.config.getTimeout());
        httpRequest.accept(this.getMediaType(this.config.getMarshallingFormat()));
        if (this.config.getUserName() != null && this.config.getPassword() != null) {
            httpRequest.basicAuthorization(this.config.getUserName(), this.config.getPassword());
        }
        return httpRequest;
    }

    private ServiceResponsesList executeJmsCommand(CommandScript command) {
        ConnectionFactory factory = this.config.getConnectionFactory();
        Queue sendQueue = this.config.getRequestQueue();
        Queue responseQueue = this.config.getResponseQueue();
        Connection connection = null;
        Session session = null;
        ServiceResponsesList cmdResponse = null;
        String corrId = UUID.randomUUID().toString();
        String selector = "JMSCorrelationID = '" + corrId + "'";
        try {
            Message response;
            Marshaller marshaller;
            MessageConsumer consumer;
            MessageProducer producer;
            try {
                connection = this.config.getPassword() != null ? factory.createConnection(this.config.getUserName(), this.config.getPassword()) : factory.createConnection();
                session = connection.createSession(false, 1);
                producer = session.createProducer((Destination)sendQueue);
                consumer = session.createConsumer((Destination)responseQueue, selector);
                connection.start();
            }
            catch (JMSException jmse) {
                throw new KieServicesException("Unable to setup a JMS connection.", jmse);
            }
            try {
                marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)this.config.getMarshallingFormat(), (ClassLoader)CommandScript.class.getClassLoader());
                String xmlStr = marshaller.marshall((Object)command);
                TextMessage textMsg = session.createTextMessage(xmlStr);
                textMsg.setJMSCorrelationID(corrId);
                textMsg.setIntProperty("serialization_format", this.config.getMarshallingFormat().getId());
                producer.send((Message)textMsg);
            }
            catch (JMSException jmse) {
                throw new KieServicesException("Unable to send a JMS message.", jmse);
            }
            try {
                response = consumer.receive(this.config.getTimeout());
            }
            catch (JMSException jmse) {
                jmse.printStackTrace();
                throw new KieServicesException("Unable to receive or retrieve the JMS response.", jmse);
            }
            if (response == null) {
                logger.warn("Response is empty");
                ServiceResponsesList jmse = null;
                return jmse;
            }
            assert (response != null) : "Response is empty.";
            try {
                String responseStr = ((TextMessage)response).getText();
                ServiceResponsesList serviceResponsesList = cmdResponse = (ServiceResponsesList)marshaller.unmarshall(responseStr, ServiceResponsesList.class);
                return serviceResponsesList;
            }
            catch (JMSException jmse) {
                throw new KieServicesException("Unable to extract " + ServiceResponsesList.class.getSimpleName() + " instance from JMS response.", jmse);
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                    if (session != null) {
                        session.close();
                    }
                }
                catch (JMSException jmse) {
                    logger.warn("Unable to close connection or session!", (Throwable)jmse);
                }
            }
        }
    }

    private String getMediaType(MarshallingFormat format) {
        switch (format) {
            case JAXB: {
                return "application/xml";
            }
            case JSON: {
                return "application/json";
            }
        }
        return "application/xml";
    }

    private String serialize(Object object) {
        try {
            return this.marshaller.marshall(object);
        }
        catch (MarshallingException e) {
            throw new KieServicesException("Error while serializing request data!", e);
        }
    }

    private <T> T deserialize(String content, Class<T> type) {
        try {
            return (T)this.marshaller.unmarshall(content, type);
        }
        catch (MarshallingException e) {
            throw new KieServicesException("Error while deserializing data received from server!", e);
        }
    }

    private void checkResultType(ServiceResponse<?> serviceResponse, Class<?> expectedResultType) {
        Object actualResult = serviceResponse.getResult();
        if (actualResult != null && !expectedResultType.isInstance(actualResult)) {
            throw new KieServicesException("Error while creating service response! The actual result type " + serviceResponse.getResult().getClass() + " does not match the expected type " + expectedResultType + "!");
        }
    }

    private RuntimeException createExceptionForUnexpectedResponseCode(KieRemoteHttpRequest request, KieRemoteHttpResponse response) {
        String summaryMessage = "Unexpected HTTP response code when requesting URI '" + request.getUri() + "'! Error code: " + response.code() + ", message: " + response.message();
        logger.debug(summaryMessage + ", response body: " + response.body());
        return new KieServicesException(summaryMessage);
    }
}

