/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.spring.boot.autoconfiguration.audit.replication;

import java.sql.Connection;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.CoreQueueConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.assertj.core.api.Assertions;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.task.audit.impl.model.AuditTaskImpl;
import org.jbpm.services.task.audit.impl.model.BAMTaskSummaryImpl;
import org.jbpm.services.task.audit.impl.model.TaskEventImpl;
import org.jbpm.services.task.audit.impl.model.TaskVariableImpl;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.services.api.KieServer;
import org.kie.server.spring.boot.autoconfiguration.audit.replication.ApplicationSender;
import org.kie.server.spring.boot.autoconfiguration.audit.replication.AuditDataReplicationJMSQueueConsumer;
import org.kie.server.spring.boot.autoconfiguration.audit.replication.KieJarBuildHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.MOCK, classes={ApplicationSender.class})
@TestPropertySource(locations={"classpath:application-integrationtest.properties"})
public class AuditDataReplicationKieServerTest {
    private static final Long TIMEOUT = 10000L;
    private static final String USER_GENERIC = "salaboy";
    private static final String USER_NOMINATED = "krisv";
    private static final String USER_ADMIN = "Administrator";
    @Autowired
    private EntityManagerFactory originalEntityManagerFactory;
    @Autowired
    @Qualifier(value="auditEntityManagerFactory")
    private EntityManagerFactory auditEntityManagerFactory;
    @Autowired
    private DataSource datasourceOriginal;
    @Autowired
    @Qualifier(value="datasource-replica")
    private DataSource datasourceReplica;
    @Autowired
    private KieServer kieServer;
    @Autowired
    private ProcessService processService;
    @Autowired
    private RuntimeDataService runtimeDataService;
    @Autowired
    private UserTaskService userTaskService;
    protected static final EmbeddedActiveMQ embedded = new EmbeddedActiveMQ();
    @Autowired
    @Qualifier(value="auditDataReplicationConsumer")
    private AuditDataReplicationJMSQueueConsumer consumer;

    @BeforeClass
    public static void startUp() throws Exception {
        KieJarBuildHelper.createKieJar("src/test/resources/kjar/");
        ConfigurationImpl config = new ConfigurationImpl();
        config.setSecurityEnabled(false);
        config.addAcceptorConfiguration("amqp-acceptor", "tcp://localhost:10022?protocols=AMQP");
        CoreQueueConfiguration auditQueue = new CoreQueueConfiguration();
        auditQueue.setAddress("audit-queue");
        auditQueue.setRoutingType(RoutingType.ANYCAST);
        auditQueue.setName("audit-queue");
        config.addQueueConfiguration(auditQueue);
        embedded.setConfiguration((Configuration)config);
        embedded.start();
    }

    @AfterClass
    public static void shutDown() throws Exception {
        embedded.stop();
    }

    @Before
    public void reset() throws Exception {
        this.clearDatasource(this.datasourceOriginal);
        this.clearDatasource(this.datasourceReplica);
        this.consumer.reset();
        KieContainerResource resource = new KieContainerResource();
        resource.setReleaseId(new ReleaseId("org.kie", "spring-boot-kjar-test", "1.0.0-SNAPSHOT"));
        resource.addConfigItem(new KieServerConfigItem());
        this.kieServer.createContainer("test", resource);
    }

    @Test
    public void testSimpleProcess() throws Exception {
        this.processService.startProcess("test", "kjar.simple-process");
        this.waitForEventProcessing(15L);
        this.compareData();
    }

    @Test
    public void testSimpleHumanTaskProcess() throws Exception {
        Long processInstanceId = this.processService.startProcess("test", "kjar.simple-ht-process", Collections.singletonMap("my var", "my var value"));
        List tasks = this.runtimeDataService.getTasksByProcessInstanceId(processInstanceId);
        tasks.forEach(e -> this.userTaskService.release(e, USER_GENERIC));
        tasks.forEach(e -> this.userTaskService.claim(e, USER_GENERIC));
        tasks.forEach(e -> this.userTaskService.start(e, USER_GENERIC));
        tasks.forEach(e -> this.userTaskService.saveContentFromUser(e, USER_GENERIC, Collections.singletonMap("my key 1", "my value 1")));
        tasks.forEach(e -> this.userTaskService.suspend(e, USER_GENERIC));
        tasks.forEach(e -> this.userTaskService.resume(e, USER_GENERIC));
        tasks.forEach(e -> this.userTaskService.complete(e, USER_GENERIC, Collections.emptyMap()));
        this.waitForEventProcessing(50L);
        this.compareData();
    }

    @Test
    public void testSimpleHumanTaskSkipProcess() throws Exception {
        Long processInstanceId = this.processService.startProcess("test", "kjar.simple-ht-process", Collections.singletonMap("my var", "my var value"));
        List tasks = this.runtimeDataService.getTasksByProcessInstanceId(processInstanceId);
        tasks.forEach(e -> this.userTaskService.release(e, USER_GENERIC));
        tasks.forEach(e -> this.userTaskService.forward(e, USER_GENERIC, USER_NOMINATED));
        tasks.forEach(e -> this.userTaskService.skip(e, USER_NOMINATED));
        this.waitForEventProcessing(35L);
        this.compareData();
    }

    @Test
    public void testSimpleHumanTaskExitProcess() throws Exception {
        Long processInstanceId = this.processService.startProcess("test", "kjar.simple-ht-process", Collections.singletonMap("my var", "my var value"));
        List tasks = this.runtimeDataService.getTasksByProcessInstanceId(processInstanceId);
        tasks.forEach(e -> this.userTaskService.exit(e, USER_ADMIN));
        this.waitForEventProcessing(19L);
        this.compareData();
    }

    @Test
    public void testSimpleHumanTaskFailProcess() throws Exception {
        Long processInstanceId = this.processService.startProcess("test", "kjar.simple-ht-process", Collections.singletonMap("my var", "my var value"));
        List tasks = this.runtimeDataService.getTasksByProcessInstanceId(processInstanceId);
        tasks.forEach(e -> this.userTaskService.start(e, USER_GENERIC));
        tasks.forEach(e -> this.userTaskService.fail(e, USER_ADMIN, Collections.emptyMap()));
        this.waitForEventProcessing(32L);
        this.compareData();
    }

    private boolean compareData() {
        EntityManager original = this.originalEntityManagerFactory.createEntityManager();
        EntityManager audit = this.auditEntityManagerFactory.createEntityManager();
        List pil = audit.createQuery("SELECT o FROM ProcessInstanceLog o ORDER BY o.id ASC", ProcessInstanceLog.class).getResultList();
        List pil_a = original.createQuery("SELECT o FROM ProcessInstanceLog o ORDER BY o.id ASC", ProcessInstanceLog.class).getResultList();
        Assertions.assertThat((List)pil).containsExactlyElementsOf((Iterable)pil_a);
        List nil = audit.createQuery("SELECT o FROM NodeInstanceLog o ORDER BY o.id ASC", NodeInstanceLog.class).getResultList();
        List nil_a = original.createQuery("SELECT o FROM NodeInstanceLog o ORDER BY o.id ASC", NodeInstanceLog.class).getResultList();
        Assertions.assertThat((List)nil).containsExactlyElementsOf((Iterable)nil_a);
        List vil = audit.createQuery("SELECT o FROM VariableInstanceLog o ORDER BY o.id ASC", VariableInstanceLog.class).getResultList();
        List vil_a = original.createQuery("SELECT o FROM VariableInstanceLog o ORDER BY o.id ASC", VariableInstanceLog.class).getResultList();
        Assertions.assertThat((List)vil).containsExactlyElementsOf((Iterable)vil_a);
        List btl = audit.createQuery("SELECT o FROM BAMTaskSummaryImpl o ORDER BY o.pk ASC", BAMTaskSummaryImpl.class).getResultList();
        List btl_a = original.createQuery("SELECT o FROM BAMTaskSummaryImpl o ORDER BY o.pk ASC", BAMTaskSummaryImpl.class).getResultList();
        Assertions.assertThat((List)btl).containsExactlyElementsOf((Iterable)btl_a);
        List tvl = audit.createQuery("SELECT o FROM TaskVariableImpl o ORDER BY o.id ASC", TaskVariableImpl.class).getResultList();
        List tvl_a = original.createQuery("SELECT o FROM TaskVariableImpl o ORDER BY o.id ASC", TaskVariableImpl.class).getResultList();
        Assertions.assertThat((List)tvl).containsAll((Iterable)tvl_a);
        List atl = audit.createQuery("SELECT o FROM AuditTaskImpl o ORDER BY o.id ASC", AuditTaskImpl.class).getResultList();
        List atl_a = original.createQuery("SELECT o FROM AuditTaskImpl o ORDER BY o.id ASC", AuditTaskImpl.class).getResultList();
        Assertions.assertThat((List)atl).containsExactlyElementsOf((Iterable)atl_a);
        List tel = audit.createQuery("SELECT o FROM TaskEventImpl o ORDER BY o.id ASC", TaskEventImpl.class).getResultList();
        List tel_a = original.createQuery("SELECT o FROM TaskEventImpl o ORDER BY o.id ASC", TaskEventImpl.class).getResultList();
        Assertions.assertThat((List)tel).containsExactlyElementsOf((Iterable)tel_a);
        original.close();
        audit.close();
        return true;
    }

    private void waitForEventProcessing(long total) throws Exception {
        long count = -1L;
        long start = System.currentTimeMillis();
        while (count != total && start + TIMEOUT > System.currentTimeMillis() && total != this.consumer.get()) {
            Thread.sleep(100L);
        }
    }

    private void clearDatasource(DataSource datasource) {
        try (Connection c = datasource.getConnection();
             Statement s = c.createStatement();){
            s.execute("TRUNCATE TABLE ProcessInstanceLog");
            s.execute("TRUNCATE TABLE NodeInstanceLog");
            s.execute("TRUNCATE TABLE VariableInstanceLog");
            s.execute("TRUNCATE TABLE BAMTaskSummary");
            s.execute("TRUNCATE TABLE TaskVariableImpl");
            s.execute("TRUNCATE TABLE AuditTaskImpl");
            s.execute("TRUNCATE TABLE TaskEvent");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

