/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.spring.boot.autoconfiguration.audit.replication;

import java.util.List;
import org.jbpm.process.audit.AbstractAuditLoggerAdapter;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.event.process.SLAViolatedEvent;
import org.kie.server.spring.boot.autoconfiguration.audit.replication.JMSSender;
import org.springframework.beans.factory.annotation.Autowired;

public class AuditDataReplicationProcessEventProducer
extends AbstractAuditLoggerAdapter {
    @Autowired
    private JMSSender jmsSender;

    protected void processStarted(ProcessStartedEvent event) {
        ProcessInstanceLog log = (ProcessInstanceLog)this.getProcessInstanceMetadata(event.getProcessInstance(), "ProcessInstanceLog");
        if (log != null) {
            this.jmsSender.sendMessage(log, 100);
        }
    }

    protected void processCompleted(ProcessCompletedEvent event) {
        ProcessInstanceLog log = (ProcessInstanceLog)this.getProcessInstanceMetadata(event.getProcessInstance(), "ProcessInstanceLog");
        if (log != null) {
            this.jmsSender.sendMessage(log, 101);
        }
    }

    protected void nodeEnter(ProcessNodeTriggeredEvent event) {
        NodeInstanceLog log = (NodeInstanceLog)this.getNodeInstanceMetadata(event.getNodeInstance(), "NodeInstanceLog");
        if (log != null) {
            this.jmsSender.sendMessage(log, 102);
        }
    }

    public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
        super.beforeNodeTriggered(event);
        NodeInstanceLog log = (NodeInstanceLog)this.getNodeInstanceMetadata(event.getNodeInstance(), "NodeInstanceLog");
        if (log != null) {
            this.jmsSender.sendMessage(log, 103);
        }
    }

    protected void nodeLeft(ProcessNodeLeftEvent event) {
        NodeInstanceLog log = (NodeInstanceLog)this.getNodeInstanceMetadata(event.getNodeInstance(), "NodeInstanceLog");
        if (log != null) {
            this.jmsSender.sendMessage(log, 103);
        }
    }

    protected void variableChanged(ProcessVariableChangedEvent event) {
        List logs = (List)this.getProcessInstanceMetadata(event.getProcessInstance(), "VariableInstanceLog");
        if (logs != null) {
            logs.forEach(log -> this.jmsSender.sendMessage(log, 104));
        }
    }

    protected void slaProcessInstanceViolated(SLAViolatedEvent event) {
        ProcessInstanceLog log = (ProcessInstanceLog)this.getProcessInstanceMetadata(event.getProcessInstance(), "ProcessInstanceLog");
        if (log != null) {
            this.jmsSender.sendMessage(log, 105);
        }
    }

    protected void slaNodeInstanceViolated(SLAViolatedEvent event) {
        NodeInstanceLog log = (NodeInstanceLog)this.getNodeInstanceMetadata(event.getNodeInstance(), "NodeInstanceLog");
        if (log != null) {
            this.jmsSender.sendMessage(log, 106);
        }
    }
}

