/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.spring.boot.autoconfiguration.audit.replication;

import com.thoughtworks.xstream.XStream;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.core.JmsTemplate;

public class JMSSender {
    private static Logger logger = LoggerFactory.getLogger(JMSSender.class);
    @Autowired
    private JmsTemplate jmsTemplate;
    @Autowired
    private XStream xstream;
    private String endpointName;

    public JMSSender(String endpointName) {
        this.endpointName = endpointName;
    }

    protected void sendMessage(Object messageContent, Integer eventType) {
        String eventXml = this.xstream.toXML(messageContent);
        logger.debug("XML Event: \n {}", (Object)eventXml);
        this.jmsTemplate.send(this.endpointName, messageCreator -> {
            TextMessage message = messageCreator.createTextMessage(eventXml);
            message.setIntProperty("EventType", eventType.intValue());
            return message;
        });
    }
}

