/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot.autoconfiguration.drools;

import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.dmn.DMNKieServerExtension;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.springboot.autoconfiguration.KieServerProperties;
import org.kie.server.springboot.autoconfiguration.drools.DroolsKieServerAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={KieServerImpl.class})
@AutoConfigureAfter(value={DroolsKieServerAutoConfiguration.class})
@EnableConfigurationProperties(value={KieServerProperties.class})
public class DMNKieServerAutoConfiguration {
    private KieServerProperties properties;

    public DMNKieServerAutoConfiguration(KieServerProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(name={"dmnServerExtension"})
    @ConditionalOnProperty(name={"kieserver.dmn.enabled"})
    public KieServerExtension dmnServerExtension() {
        return new DMNKieServerExtension();
    }
}

