/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot.autoconfiguration.jbpm;

import org.jbpm.casemgmt.api.CaseRuntimeDataService;
import org.jbpm.casemgmt.api.CaseService;
import org.jbpm.casemgmt.api.admin.CaseInstanceMigrationService;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.springboot.autoconfiguration.KieServerProperties;
import org.kie.server.springboot.autoconfiguration.jbpm.JBPMKieServerAutoConfiguration;
import org.kie.server.springboot.autoconfiguration.jbpm.extensions.SpringBootCaseKieServerExtension;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={KieServerImpl.class})
@AutoConfigureAfter(value={JBPMKieServerAutoConfiguration.class})
@EnableConfigurationProperties(value={KieServerProperties.class})
public class CaseMgmtKieServerAutoConfiguration {
    private KieServerProperties properties;
    private CaseService caseService;
    private CaseRuntimeDataService caseRuntimeDataService;
    private CaseInstanceMigrationService caseInstanceMigrationService;

    public CaseMgmtKieServerAutoConfiguration(KieServerProperties properties, CaseService caseService, CaseRuntimeDataService caseRuntimeDataService, CaseInstanceMigrationService caseInstanceMigrationService) {
        this.properties = properties;
        this.caseService = caseService;
        this.caseRuntimeDataService = caseRuntimeDataService;
        this.caseInstanceMigrationService = caseInstanceMigrationService;
    }

    @Bean
    @ConditionalOnMissingBean(name={"caseMgmtServerExtension"})
    @ConditionalOnProperty(name={"kieserver.casemgmt.enabled"})
    public KieServerExtension caseMgmtServerExtension() {
        return new SpringBootCaseKieServerExtension(this.caseService, this.caseRuntimeDataService, this.caseInstanceMigrationService);
    }
}

