/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot.samples;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.provisioning.UserDetailsManager;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.firewall.StrictHttpFirewall;

@Configuration(value="kieServerSecurity")
@EnableWebSecurity
public class IntegrationTestsWebSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final String USER_PASSWORD = "usetheforce123@";
    private static final String KIE_SERVER_ROLE = "kie-server";
    private static final String GUEST_ROLE = "guest";
    private static final String ADMIN_ROLE = "Administrators";
    private static final String ENGINEERING_ROLE = "engineering";
    private static final String HR_ROLE = "HR";
    private static final String IT_ROLE = "IT";
    private static final String ACCOUNTING_ROLE = "Accounting";

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().antMatchers(new String[]{"/**/server/readycheck"})).permitAll().regexMatchers(new String[]{".*swagger.json", ".*swagger-ui.js", ".*/css/.*css", ".*/lib/.*js", ".*/images/.*png"})).permitAll().anyRequest()).authenticated().and()).httpBasic();
    }

    @Bean
    public HttpFirewall customStrictHttpFirewall() {
        StrictHttpFirewall firewall = new StrictHttpFirewall();
        firewall.setAllowUrlEncodedPercent(true);
        return firewall;
    }

    @Bean
    public UserDetailsManager userDetailsService() {
        InMemoryUserDetailsManager manager = new InMemoryUserDetailsManager();
        PasswordEncoder encoder = PasswordEncoderFactories.createDelegatingPasswordEncoder();
        manager.createUser(User.withUsername((String)"yoda").password(encoder.encode((CharSequence)USER_PASSWORD)).roles(new String[]{KIE_SERVER_ROLE, GUEST_ROLE}).build());
        manager.createUser(User.withUsername((String)"administrator").password(encoder.encode((CharSequence)USER_PASSWORD)).roles(new String[]{KIE_SERVER_ROLE, GUEST_ROLE, ADMIN_ROLE}).build());
        manager.createUser(User.withUsername((String)"john").password(encoder.encode((CharSequence)USER_PASSWORD)).roles(new String[]{KIE_SERVER_ROLE, GUEST_ROLE, ENGINEERING_ROLE, HR_ROLE, IT_ROLE, ACCOUNTING_ROLE}).build());
        manager.createUser(User.withUsername((String)"mary").password(encoder.encode((CharSequence)USER_PASSWORD)).roles(new String[]{KIE_SERVER_ROLE, GUEST_ROLE, ENGINEERING_ROLE, HR_ROLE, IT_ROLE, ACCOUNTING_ROLE}).build());
        return manager;
    }
}

