/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot.samples;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.read.ListAppender;
import java.util.Collections;
import java.util.Optional;
import org.apache.kafka.common.errors.TimeoutException;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ProcessService;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.server.springboot.samples.KafkaFixture;
import org.kie.server.springboot.samples.TestAutoConfiguration;
import org.kie.server.springboot.samples.kafka.KieServerApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@SpringBootTest(classes={KieServerApplication.class, TestAutoConfiguration.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@TestPropertySource(locations={"classpath:application-test.properties"})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
public class KafkaEmitterBrokerDownTest
extends KafkaFixture {
    @Autowired
    protected DeploymentService deploymentService;
    @Autowired
    protected ProcessService processService;
    protected String deploymentId;

    @BeforeClass
    public static void beforeClass() {
        KafkaEmitterBrokerDownTest.generalSetup(false);
        System.setProperty("org.kie.jbpm.event.emitters.kafka.max.block.ms", "500");
    }

    @After
    public void cleanup() {
        this.cleanup(this.deploymentService);
        System.clearProperty("org.kie.jbpm.event.emitters.kafka.max.block.ms");
    }

    @Test(timeout=30000L)
    public void testEmitterNoKafkaBrokerTimeoutException() {
        this.deploymentId = this.setup(this.deploymentService, "evaluation");
        ListAppender<ILoggingEvent> listAppender = this.addLogAppender();
        Long processInstanceId = this.processService.startProcess(this.deploymentId, "evaluation", Collections.singletonMap("initiator", "yoda"));
        Optional<ILoggingEvent> logEvent = this.getLog(listAppender);
        Assert.assertEquals((Object)TimeoutException.class.getCanonicalName(), (Object)logEvent.get().getThrowableProxy().getClassName());
        Assert.assertNotNull((Object)processInstanceId);
        Assert.assertTrue((processInstanceId > 0L ? 1 : 0) != 0);
        this.processService.abortProcessInstance(processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(processInstanceId);
        Assert.assertNull((Object)pi);
    }
}

