/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.springboot.samples;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.read.ListAppender;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.jbpm.casemgmt.api.CaseService;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.UserTaskService;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryFilter;
import org.kie.server.springboot.samples.KafkaFixture;
import org.kie.server.springboot.samples.TestAutoConfiguration;
import org.kie.server.springboot.samples.kafka.KieServerApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.testcontainers.containers.KafkaContainer;

@RunWith(value=SpringJUnit4ClassRunner.class)
@SpringBootTest(classes={KieServerApplication.class, TestAutoConfiguration.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@TestPropertySource(locations={"classpath:application-test.properties"})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
public class KafkaEmitterHappyPathTest
extends KafkaFixture {
    protected static KafkaContainer kafka = new KafkaContainer();
    @Autowired
    protected DeploymentService deploymentService;
    @Autowired
    protected ProcessService processService;
    @Autowired
    protected CaseService caseService;
    @Autowired
    protected UserTaskService userTaskService;
    @Autowired
    protected RuntimeDataService runtimeDataService;
    protected String deploymentId;

    @BeforeClass
    public static void beforeClass() {
        Assume.assumeTrue((boolean)KafkaEmitterHappyPathTest.isDockerAvailable());
        kafka.start();
        bootstrapServers = kafka.getBootstrapServers();
        KafkaEmitterHappyPathTest.generalSetup(true);
    }

    @After
    public void cleanup() {
        this.cleanup(this.deploymentService);
    }

    @AfterClass
    public static void teardown() {
        kafka.stop();
        System.clearProperty("org.kie.jbpm.event.emitters.kafka.bootstrap.servers");
        System.clearProperty("org.kie.jbpm.event.emitters.kafka.client.id");
    }

    @Test(timeout=30000L)
    public void testKafkaEmitterProcessStartAndAbort() {
        this.deploymentId = this.setup(this.deploymentService, "evaluation");
        Long processInstanceId = this.processService.startProcess(this.deploymentId, "evaluation", this.initParameters());
        Assert.assertNotNull((Object)processInstanceId);
        Assert.assertTrue((processInstanceId > 0L ? 1 : 0) != 0);
        this.consumeAndAssertRecords("jbpm-processes-events", "process", 1, 1);
        this.processService.abortProcessInstance(processInstanceId);
        ProcessInstance pi = this.processService.getProcessInstance(processInstanceId);
        Assert.assertNull((Object)pi);
        this.consumeAndAssertRecords("jbpm-processes-events", "process", 3, 1);
    }

    @Test(timeout=30000L)
    public void testKafkaEmitterProcessStartAndWorkOnUserTasks() {
        this.deploymentId = this.setup(this.deploymentService, "evaluation");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("employee", "john");
        parameters.put("reason", "autoevaluation");
        Long processInstanceId = this.processService.startProcess(this.deploymentId, "evaluation", parameters);
        Assert.assertNotNull((Object)processInstanceId);
        Assert.assertTrue((processInstanceId > 0L ? 1 : 0) != 0);
        List tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.userTaskService.completeAutoProgress(((TaskSummary)tasks.get(0)).getId(), "john", new HashMap());
        tasks = this.runtimeDataService.getTasksAssignedAsPotentialOwner("john", new QueryFilter());
        Assert.assertEquals((long)2L, (long)tasks.size());
        tasks.forEach(t -> this.userTaskService.completeAutoProgress(t.getId(), "john", new HashMap()));
        ProcessInstance pi = this.processService.getProcessInstance(processInstanceId);
        Assert.assertNull((Object)pi);
        ConsumerRecords records = this.consumeMessages("jbpm-tasks-events");
        Assert.assertEquals((long)11L, (long)records.count());
        Map<String, Long> taskRecordsByStatus = this.groupRecordsByField(records, "status");
        Assert.assertEquals((long)2L, (long)taskRecordsByStatus.get(Status.Ready.name()).intValue());
        Assert.assertEquals((long)3L, (long)taskRecordsByStatus.get(Status.Reserved.name()).intValue());
        Assert.assertEquals((long)3L, (long)taskRecordsByStatus.get(Status.InProgress.name()).intValue());
        Assert.assertEquals((long)3L, (long)taskRecordsByStatus.get(Status.Completed.name()).intValue());
        records = this.consumeMessages("jbpm-processes-events");
        Assert.assertEquals((long)4L, (long)records.count());
        Map<String, Long> processRecordsByStatus = this.groupRecordsByField(records, "state");
        Assert.assertEquals((long)3L, (long)processRecordsByStatus.get("1").intValue());
        Assert.assertEquals((long)1L, (long)processRecordsByStatus.get("2").intValue());
    }

    @Test(timeout=30000L)
    public void testKafkaEmitterCaseStartAndAbort() {
        this.deploymentId = this.setup(this.deploymentService, "user-task-case");
        CaseFileInstance caseFileInstance = this.caseService.newCaseFileInstance(this.deploymentId, "user-task-case", this.caseFile(50000).getData(), this.roleAssignments());
        String caseId = this.caseService.startCase(this.deploymentId, "user-task-case", caseFileInstance);
        Assert.assertNotNull((Object)caseId);
        this.consumeAndAssertRecords("jbpm-cases-events", "case", 1, 1);
        this.caseService.cancelCase(caseId);
        this.consumeAndAssertRecords("jbpm-cases-events", "case", 3, 1);
        ConsumerRecords records = this.consumeMessages("jbpm-tasks-events");
        Assert.assertEquals((long)2L, (long)records.count());
    }

    @Test(timeout=30000L)
    public void testEmitterRecordTooLargeException() {
        this.deploymentId = this.setup(this.deploymentService, "user-task-case");
        ListAppender<ILoggingEvent> listAppender = this.addLogAppender();
        CaseFileInstance caseFileInstance = this.caseService.newCaseFileInstance(this.deploymentId, "user-task-case", this.caseFile(500000).getData(), this.roleAssignments());
        String caseId = this.caseService.startCase(this.deploymentId, "user-task-case", caseFileInstance);
        Assert.assertNotNull((Object)caseId);
        Optional<ILoggingEvent> logEvent = this.getLog(listAppender);
        Assert.assertEquals((Object)RecordTooLargeException.class.getCanonicalName(), (Object)logEvent.get().getThrowableProxy().getClassName());
        this.consumeAndAssertRecords("jbpm-cases-events", "case", 1, 0);
        this.caseService.cancelCase(caseId);
        this.consumeAndAssertRecords("jbpm-cases-events", "case", 3, 0);
        ConsumerRecords records = this.consumeMessages("jbpm-tasks-events");
        Assert.assertEquals((long)2L, (long)records.count());
    }
}

