/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.tests.persistence;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.drools.compiler.compiler.PackageBuilder;
import org.drools.core.process.core.Work;
import org.drools.core.process.core.impl.WorkImpl;
import org.drools.core.rule.Package;
import org.drools.core.util.DroolsStreamUtils;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.jbpm.compiler.ProcessBuilderImpl;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.node.SubProcessNodeInstance;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.persistence.jpa.KieStoreServices;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.spring.beans.persistence.TestWorkItemHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class JPASingleSessionCommandServiceFactoryEnvTest {
    private static String TMPDIR = System.getProperty("java.io.tmpdir");
    private static final Logger log = LoggerFactory.getLogger(JPASingleSessionCommandServiceFactoryEnvTest.class);
    private static Server h2Server;
    private ApplicationContext ctx;

    @BeforeClass
    public static void startH2Database() throws Exception {
        DeleteDbFiles.execute((String)"", (String)"DroolsFlow", (boolean)true);
        h2Server = Server.createTcpServer((String[])new String[0]);
        h2Server.start();
        try {
            TMPDIR = JPASingleSessionCommandServiceFactoryEnvTest.class.getResource("/kb_persistence").getFile();
            log.info("creating: {}", (Object)(TMPDIR + "/processWorkItems.pkg"));
            JPASingleSessionCommandServiceFactoryEnvTest.writePackage(JPASingleSessionCommandServiceFactoryEnvTest.getProcessWorkItems(), new File(TMPDIR + "/processWorkItems.pkg"));
            log.info("creating: {}", (Object)(TMPDIR + "/processSubProcess.pkg"));
            JPASingleSessionCommandServiceFactoryEnvTest.writePackage(JPASingleSessionCommandServiceFactoryEnvTest.getProcessSubProcess(), new File(TMPDIR + "/processSubProcess.pkg"));
            log.info("creating: {}", (Object)(TMPDIR + "/processTimer.pkg"));
            JPASingleSessionCommandServiceFactoryEnvTest.writePackage(JPASingleSessionCommandServiceFactoryEnvTest.getProcessTimer(), new File(TMPDIR + "/processTimer.pkg"));
            log.info("creating: {}", (Object)(TMPDIR + "/processTimer2.pkg"));
            JPASingleSessionCommandServiceFactoryEnvTest.writePackage(JPASingleSessionCommandServiceFactoryEnvTest.getProcessTimer2(), new File(TMPDIR + "/processTimer2.pkg"));
        }
        catch (Exception e) {
            log.error("can't create packages!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @AfterClass
    public static void stopH2Database() throws Exception {
        log.info("stopping database");
        h2Server.stop();
        DeleteDbFiles.execute((String)"", (String)"DroolsFlow", (boolean)true);
    }

    @Before
    public void createSpringContext() {
        try {
            log.info("creating spring context");
            this.ctx = new ClassPathXmlApplicationContext("org/kie/spring/persistence/persistence_beans_env.xml");
        }
        catch (Exception e) {
            log.error("can't create spring context", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @After
    public void destroySpringContext() {
        log.info("destroy spring context");
    }

    @Test
    public void testPersistenceWorkItems() throws Exception {
        log.info("---> get bean jpaSingleSessionCommandService");
        KieSession service = (KieSession)this.ctx.getBean("jpaSingleSessionCommandService2");
        log.info("---> create new SingleSessionCommandService");
        int sessionId = service.getId();
        log.info("---> created SingleSessionCommandService id: " + sessionId);
        ProcessInstance processInstance = service.startProcess("org.drools.test.TestProcess");
        log.info("Started process instance {}", (Object)processInstance.getId());
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        Environment env = (Environment)this.ctx.getBean("env");
        KieStoreServices kstore = (KieStoreServices)this.ctx.getBean("kstore1");
        KieBase kbase1 = (KieBase)this.ctx.getBean("kb_persistence");
        service = kstore.loadKieSession(sessionId, kbase1, null, env);
        processInstance = service.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        service.dispose();
        service = kstore.loadKieSession(sessionId, kbase1, null, env);
        service.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        service = kstore.loadKieSession(sessionId, kbase1, null, env);
        processInstance = service.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        service.dispose();
        service = kstore.loadKieSession(sessionId, kbase1, null, env);
        service.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        service = kstore.loadKieSession(sessionId, kbase1, null, env);
        processInstance = service.getProcessInstance(processInstance.getId());
        service.dispose();
        service = kstore.loadKieSession(sessionId, kbase1, null, env);
        service.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNull((Object)workItem);
        service.dispose();
        service = kstore.loadKieSession(sessionId, kbase1, null, env);
        processInstance = service.getProcessInstance(processInstance.getId());
        service.dispose();
    }

    @Test
    public void testPersistenceWorkItemsUserTransaction() throws Exception {
        KieSession service = (KieSession)this.ctx.getBean("jpaSingleSessionCommandService2");
        int sessionId = service.getId();
        ProcessInstance processInstance = service.startProcess("org.drools.test.TestProcess");
        log.info("Started process instance {}", (Object)processInstance.getId());
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        Environment env = (Environment)this.ctx.getBean("env");
        KieStoreServices kstore = (KieStoreServices)this.ctx.getBean("kstore1");
        KieBase kbase1 = (KieBase)this.ctx.getBean("kb_persistence");
        service = kstore.loadKieSession(sessionId, kbase1, null, env);
        processInstance = service.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        service.dispose();
        service = kstore.loadKieSession(sessionId, kbase1, null, env);
        service.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        service = kstore.loadKieSession(sessionId, kbase1, null, env);
        processInstance = service.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        service.dispose();
        service = kstore.loadKieSession(sessionId, kbase1, null, env);
        service.getWorkItemManager().abortWorkItem(workItem.getId());
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        service = kstore.loadKieSession(sessionId, kbase1, null, env);
        processInstance = service.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        service.dispose();
        service = kstore.loadKieSession(sessionId, kbase1, null, env);
        service.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNull((Object)workItem);
        service.dispose();
        service = kstore.loadKieSession(sessionId, kbase1, null, env);
        processInstance = service.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        service.dispose();
    }

    private static Package getProcessWorkItems() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.TestProcess");
        process.setName("TestProcess");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        ActionNode actionNode = new ActionNode();
        actionNode.setId(2L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setId(3L);
        workItemNode.setName("WorkItem1");
        WorkImpl work = new WorkImpl();
        work.setName("MyWork");
        workItemNode.setWork((Work)work);
        process.addNode((Node)workItemNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)workItemNode, "DROOLS_DEFAULT");
        WorkItemNode workItemNode2 = new WorkItemNode();
        workItemNode2.setId(4L);
        workItemNode2.setName("WorkItem2");
        work = new WorkImpl();
        work.setName("MyWork");
        workItemNode2.setWork((Work)work);
        process.addNode((Node)workItemNode2);
        new ConnectionImpl((Node)workItemNode, "DROOLS_DEFAULT", (Node)workItemNode2, "DROOLS_DEFAULT");
        WorkItemNode workItemNode3 = new WorkItemNode();
        workItemNode3.setId(5L);
        workItemNode3.setName("WorkItem3");
        work = new WorkImpl();
        work.setName("MyWork");
        workItemNode3.setWork((Work)work);
        process.addNode((Node)workItemNode3);
        new ConnectionImpl((Node)workItemNode2, "DROOLS_DEFAULT", (Node)workItemNode3, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(6L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)workItemNode3, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        PackageBuilder packageBuilder = new PackageBuilder();
        ProcessBuilderImpl processBuilder = new ProcessBuilderImpl(packageBuilder);
        processBuilder.buildProcess((Process)process, null);
        return packageBuilder.getPackage();
    }

    public static void writePackage(Package pkg, File dest) {
        dest.deleteOnExit();
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(dest));
            DroolsStreamUtils.streamOut((OutputStream)out, (Object)pkg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Test
    public void testPersistenceSubProcess() {
        KieSession service = (KieSession)this.ctx.getBean("jpaSingleSessionCommandService2");
        int sessionId = service.getId();
        RuleFlowProcessInstance processInstance = (RuleFlowProcessInstance)service.startProcess("org.drools.test.ProcessSubProcess");
        log.info("Started process instance {}", (Object)processInstance.getId());
        long processInstanceId = processInstance.getId();
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        Environment env = (Environment)this.ctx.getBean("env");
        KieStoreServices kstore = (KieStoreServices)this.ctx.getBean("kstore1");
        KieBase kbase1 = (KieBase)this.ctx.getBean("kb_persistence");
        service = kstore.loadKieSession(sessionId, kbase1, null, env);
        processInstance = (RuleFlowProcessInstance)service.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        Collection nodeInstances = processInstance.getNodeInstances();
        Assert.assertEquals((long)1L, (long)nodeInstances.size());
        SubProcessNodeInstance subProcessNodeInstance = (SubProcessNodeInstance)nodeInstances.iterator().next();
        long subProcessInstanceId = subProcessNodeInstance.getProcessInstanceId();
        RuleFlowProcessInstance subProcessInstance = (RuleFlowProcessInstance)service.getProcessInstance(subProcessInstanceId);
        Assert.assertNotNull((Object)subProcessInstance);
        service.dispose();
        service = kstore.loadKieSession(sessionId, kbase1, null, env);
        service.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        service.dispose();
        service = kstore.loadKieSession(sessionId, kbase1, null, env);
        subProcessInstance = (RuleFlowProcessInstance)service.getProcessInstance(subProcessInstanceId);
        Assert.assertNull((Object)subProcessInstance);
        processInstance = (RuleFlowProcessInstance)service.getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
        service.dispose();
    }

    private static Package getProcessSubProcess() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.ProcessSubProcess");
        process.setName("ProcessSubProcess");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        ActionNode actionNode = new ActionNode();
        actionNode.setId(2L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        SubProcessNode subProcessNode = new SubProcessNode();
        subProcessNode.setId(3L);
        subProcessNode.setName("SubProcess");
        subProcessNode.setProcessId("org.drools.test.SubProcess");
        process.addNode((Node)subProcessNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)subProcessNode, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(4L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)subProcessNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        PackageBuilder packageBuilder = new PackageBuilder();
        ProcessBuilderImpl processBuilder = new ProcessBuilderImpl(packageBuilder);
        processBuilder.buildProcess((Process)process, null);
        process = new RuleFlowProcess();
        process.setId("org.drools.test.SubProcess");
        process.setName("SubProcess");
        process.setPackageName("org.drools.test");
        start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        actionNode = new ActionNode();
        actionNode.setId(2L);
        actionNode.setName("Action");
        action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setId(3L);
        workItemNode.setName("WorkItem1");
        WorkImpl work = new WorkImpl();
        work.setName("MyWork");
        workItemNode.setWork((Work)work);
        process.addNode((Node)workItemNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)workItemNode, "DROOLS_DEFAULT");
        end = new EndNode();
        end.setId(6L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)workItemNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        processBuilder.buildProcess((Process)process, null);
        return packageBuilder.getPackage();
    }

    @Test
    public void testPersistenceTimer() throws Exception {
        System.out.println("TMPDIR == " + TMPDIR);
        log.info("---> get bean jpaSingleSessionCommandService2");
        KieSession service = (KieSession)this.ctx.getBean("jpaSingleSessionCommandService2");
        int sessionId = service.getId();
        log.info("---> created SingleSessionCommandService id: " + sessionId);
        ProcessInstance processInstance = service.startProcess("org.drools.test.ProcessTimer");
        long procId = processInstance.getId();
        log.info("---> Started ProcessTimer id: {}", (Object)procId);
        service.dispose();
        log.info("---> session disposed");
        Environment env = (Environment)this.ctx.getBean("env");
        KieStoreServices kstore = (KieStoreServices)this.ctx.getBean("kstore1");
        KieBase kbase1 = (KieBase)this.ctx.getBean("kb_persistence");
        service = kstore.loadKieSession(sessionId, kbase1, null, env);
        log.info("---> load session: " + sessionId);
        processInstance = service.getProcessInstance(procId);
        log.info("---> GetProcessInstanceCommand id: " + procId);
        Assert.assertNotNull((Object)processInstance);
        Thread.sleep(1000L);
        log.info("---> session disposed");
        service.dispose();
        service = kstore.loadKieSession(sessionId, kbase1, null, env);
        log.info("---> load session: " + sessionId);
        Thread.sleep(3000L);
        log.info("---> GetProcessInstanceCommand id: " + procId);
        processInstance = service.getProcessInstance(procId);
        log.info("---> session disposed");
        Assert.assertNull((Object)processInstance);
    }

    private static Package getProcessTimer() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.ProcessTimer");
        process.setName("ProcessTimer");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        TimerNode timerNode = new TimerNode();
        timerNode.setId(2L);
        timerNode.setName("Timer");
        Timer timer = new Timer();
        timer.setDelay("2000");
        timerNode.setTimer(timer);
        process.addNode((Node)timerNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)timerNode, "DROOLS_DEFAULT");
        ActionNode actionNode = new ActionNode();
        actionNode.setId(3L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)timerNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(6L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        PackageBuilder packageBuilder = new PackageBuilder();
        ProcessBuilderImpl processBuilder = new ProcessBuilderImpl(packageBuilder);
        processBuilder.buildProcess((Process)process, null);
        return packageBuilder.getPackage();
    }

    @Test
    public void testPersistenceTimer2() throws Exception {
        KieSession service = (KieSession)this.ctx.getBean("jpaSingleSessionCommandService2");
        int sessionId = service.getId();
        ProcessInstance processInstance = service.startProcess("org.drools.test.ProcessTimer2");
        log.info("Started process instance {}", (Object)processInstance.getId());
        Thread.sleep(2000L);
        Environment env = (Environment)this.ctx.getBean("env");
        KieStoreServices kstore = (KieStoreServices)this.ctx.getBean("kstore1");
        KieBase kbase1 = (KieBase)this.ctx.getBean("kb_persistence");
        service = kstore.loadKieSession(sessionId, kbase1, null, env);
        processInstance = service.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
    }

    private static Package getProcessTimer2() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.ProcessTimer2");
        process.setName("ProcessTimer2");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        TimerNode timerNode = new TimerNode();
        timerNode.setId(2L);
        timerNode.setName("Timer");
        Timer timer = new Timer();
        timer.setDelay("0");
        timerNode.setTimer(timer);
        process.addNode((Node)timerNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)timerNode, "DROOLS_DEFAULT");
        ActionNode actionNode = new ActionNode();
        actionNode.setId(3L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("try { Thread.sleep(1000); } catch (Throwable t) {} System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)timerNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(6L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        PackageBuilder packageBuilder = new PackageBuilder();
        ProcessBuilderImpl processBuilder = new ProcessBuilderImpl(packageBuilder);
        processBuilder.buildProcess((Process)process, null);
        return packageBuilder.getPackage();
    }
}

