/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.timer;

import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.spring.timer.MyDroolsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class TimerFlowTest {
    private static final Logger log = LoggerFactory.getLogger(TimerFlowTest.class);
    private static final String TMPDIR = System.getProperty("java.io.tmpdir");
    private ClassPathXmlApplicationContext ctx;

    @Before
    public void createSpringContext() {
        try {
            log.info("creating spring context");
            PropertyPlaceholderConfigurer configurer = new PropertyPlaceholderConfigurer();
            Properties properties = new Properties();
            properties.setProperty("temp.dir", TMPDIR);
            configurer.setProperties(properties);
            this.ctx = new ClassPathXmlApplicationContext();
            this.ctx.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)configurer);
            this.ctx.setConfigLocation("org/kie/spring/timer/conf/spring-conf.xml");
            this.ctx.refresh();
        }
        catch (Exception e) {
            log.error("can't create spring context", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Test
    @Ignore
    public void doTest() throws Exception {
        MyDroolsBean myDroolsBean = (MyDroolsBean)this.ctx.getBean("myDroolsBean");
        Assert.assertEquals((long)0L, (long)myDroolsBean.getTimerTriggerCount());
        myDroolsBean.initStartDisposeAndLoadSession();
        int n = myDroolsBean.getTimerTriggerCount();
        Assert.assertTrue((n > 0 ? 1 : 0) != 0);
        myDroolsBean.endTheProcess();
        Assert.assertTrue((myDroolsBean.getTimerTriggerCount() > n ? 1 : 0) != 0);
    }
}

