/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.jbpm;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.spring.jbpm.AbstractJbpmSpringParameterizedTest;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@RunWith(value=Parameterized.class)
public class PerProcessInstanceSpringTest
extends AbstractJbpmSpringParameterizedTest {
    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> contextPath() {
        Object[][] data = new Object[][]{{"jbpm/local-em/per-process-instance.xml", ProcessInstanceIdContext.get()}, {"jbpm/local-emf/per-process-instance.xml", ProcessInstanceIdContext.get()}, {"jbpm/jta-em/per-process-instance.xml", ProcessInstanceIdContext.get()}, {"jbpm/jta-emf/per-process-instance.xml", ProcessInstanceIdContext.get()}};
        return Arrays.asList(data);
    }

    public PerProcessInstanceSpringTest(String contextPath, Context<?> runtimeManagerContext) {
        super(contextPath, runtimeManagerContext);
    }

    @Test
    public void testNoSessionInDbAfterInit() throws Exception {
        EntityManager entityManager = this.getEntityManager();
        List sessions = entityManager.createQuery("from SessionInfo").getResultList();
        Assert.assertNotNull((Object)sessions);
        Assert.assertEquals((long)0L, (long)sessions.size());
        this.getManager();
        sessions = entityManager.createQuery("from SessionInfo").getResultList();
        Assert.assertNotNull((Object)sessions);
        Assert.assertEquals((long)0L, (long)sessions.size());
    }

    @Test
    public void testRecoveringKieSessionByProcessInstanceIdContext() throws Exception {
        RuntimeManager manager = this.getManager();
        RuntimeEngine engine = this.getEngine();
        KieSession ksession = this.getKieSession();
        long ksessionId = ksession.getIdentifier();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        System.out.println("Process started");
        manager.disposeRuntimeEngine(engine);
        engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
        ksession = engine.getKieSession();
        TaskService taskService = engine.getTaskService();
        Assert.assertEquals((long)ksessionId, (long)ksession.getIdentifier());
        ProcessInstanceLog log = this.getLogService().findProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)log);
        List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        System.out.println("Found " + tasks.size() + " task(s) for user '" + "john" + "'");
        Assert.assertEquals((long)1L, (long)tasks.size());
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId, "john");
        taskService.complete(taskId, "john", null);
        tasks = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        System.out.println("Found " + tasks.size() + " task(s) for user '" + "mary" + "'");
        Assert.assertEquals((long)1L, (long)tasks.size());
        taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId, "mary");
        taskService.complete(taskId, "mary", null);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        System.out.println("Process instance completed");
        manager.disposeRuntimeEngine(engine);
    }

    @Test
    public void testProcessWithTaskCompletionWithDispose() throws Exception {
        RuntimeManager manager = this.getManager();
        AbstractPlatformTransactionManager transactionManager = this.getTransactionManager();
        DefaultTransactionDefinition defTransDefinition = new DefaultTransactionDefinition();
        TransactionStatus status = transactionManager.getTransaction((TransactionDefinition)defTransDefinition);
        RuntimeEngine runtime = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance pi1 = ksession.startProcess("com.sample.bpmn.hello");
        Assert.assertEquals((long)1L, (long)pi1.getState());
        List taskIds = runtime.getTaskService().getTasksByProcessInstanceId(pi1.getId());
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
        Long taskId1 = (Long)taskIds.get(0);
        runtime.getTaskService().start(taskId1.longValue(), "john");
        transactionManager.commit(status);
        status = transactionManager.getTransaction((TransactionDefinition)defTransDefinition);
        RuntimeEngine runtime2 = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession2 = runtime2.getKieSession();
        Assert.assertNotNull((Object)ksession2);
        ProcessInstance pi2 = ksession2.startProcess("com.sample.bpmn.hello");
        Assert.assertEquals((long)1L, (long)pi2.getState());
        List taskIds2 = runtime2.getTaskService().getTasksByProcessInstanceId(pi2.getId());
        Assert.assertNotNull((Object)taskIds2);
        Assert.assertEquals((long)1L, (long)taskIds2.size());
        Long taskId2 = (Long)taskIds2.get(0);
        runtime2.getTaskService().start(taskId2.longValue(), "john");
        transactionManager.commit(status);
        status = transactionManager.getTransaction((TransactionDefinition)defTransDefinition);
        runtime = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId()));
        runtime.getTaskService().complete(taskId1.longValue(), "john", null);
        transactionManager.commit(status);
        status = transactionManager.getTransaction((TransactionDefinition)defTransDefinition);
        runtime2 = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi2.getId()));
        runtime2.getTaskService().complete(taskId2.longValue(), "john", null);
        transactionManager.commit(status);
        status = transactionManager.getTransaction((TransactionDefinition)defTransDefinition);
        runtime = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId()));
        taskIds = runtime.getTaskService().getTasksByProcessInstanceId(pi1.getId());
        Assert.assertNotNull((Object)taskIds);
        Assert.assertEquals((long)2L, (long)taskIds.size());
        taskId1 = (Long)taskIds.get(1);
        runtime.getTaskService().start(taskId1.longValue(), "mary");
        runtime.getTaskService().complete(taskId1.longValue(), "mary", null);
        transactionManager.commit(status);
        try {
            manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi1.getId())).getKieSession();
            Assert.fail((String)("Session for this (" + pi1.getId() + ") process instance is no more accessible"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        status = transactionManager.getTransaction((TransactionDefinition)defTransDefinition);
        runtime2 = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi2.getId()));
        taskIds2 = runtime2.getTaskService().getTasksByProcessInstanceId(pi2.getId());
        Assert.assertNotNull((Object)taskIds2);
        Assert.assertEquals((long)2L, (long)taskIds2.size());
        taskId2 = (Long)taskIds2.get(1);
        runtime2.getTaskService().start(taskId2.longValue(), "mary");
        runtime2.getTaskService().complete(taskId2.longValue(), "mary", null);
        transactionManager.commit(status);
        try {
            manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)pi2.getId())).getKieSession();
            Assert.fail((String)("Session for this (" + pi2.getId() + ") process instance is no more accessible"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

