/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.jbpm;

import java.util.Arrays;
import java.util.Collection;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.spring.jbpm.AbstractJbpmSpringParameterizedTest;

@RunWith(value=Parameterized.class)
public class RuntimeManagerInitNoInitialContextSpringTest
extends AbstractJbpmSpringParameterizedTest {
    private static String CONTEXT_FACTORY;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> contextPath() {
        Object[][] data = new Object[][]{{"jbpm/no-initial-context/local-emf-singleton.xml", EmptyContext.get()}, {"jbpm/no-initial-context/local-emf-per-process.xml", ProcessInstanceIdContext.get()}, {"jbpm/no-initial-context/local-emf-per-request.xml", EmptyContext.get()}};
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void setUpProperty() throws Exception {
        CONTEXT_FACTORY = System.getProperty("java.naming.factory.initial");
        System.setProperty("java.naming.factory.initial", "incorrectFactory");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (CONTEXT_FACTORY != null) {
            System.setProperty("java.naming.factory.initial", CONTEXT_FACTORY);
        } else {
            System.clearProperty("java.naming.factory.initial");
        }
    }

    public RuntimeManagerInitNoInitialContextSpringTest(String contextPath, Context<?> runtimeManagerContext) {
        super(contextPath, runtimeManagerContext);
    }

    @Test
    public void testSimpleTaskInvocation() throws Exception {
        RuntimeManager manager = this.getManager();
        AuditLogService logService = this.getLogService();
        RuntimeEngine engine = this.getEngine();
        KieSession ksession = this.getKieSession();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        System.out.println("Process started");
        ProcessInstanceLog instanceLog = logService.findProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)instanceLog);
        Assert.assertEquals((long)1L, (long)instanceLog.getStatus().intValue());
        ksession.abortProcessInstance(processInstance.getId());
        System.out.println("Process instance aborted");
        instanceLog = logService.findProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)instanceLog);
        Assert.assertEquals((long)3L, (long)instanceLog.getStatus().intValue());
        manager.disposeRuntimeEngine(engine);
    }
}

