/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.jbpm;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.spring.jbpm.AbstractJbpmSpringParameterizedTest;

@RunWith(value=Parameterized.class)
public class SwimlaneSpringTest
extends AbstractJbpmSpringParameterizedTest {
    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> contextPath() {
        Object[][] data = new Object[][]{{"jbpm/usergroup-callback/local-emf-singleton.xml", EmptyContext.get()}};
        return Arrays.asList(data);
    }

    public SwimlaneSpringTest(String contextPath, Context<?> runtimeManagerContext) {
        super(contextPath, runtimeManagerContext);
    }

    @Test
    public void testCompleteTaskInSwimlane() throws Exception {
        KieSession ksession = this.getKieSession();
        TaskService taskService = this.getTaskService();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userid", "max");
        ProcessInstance processInstance = ksession.startProcess("agu.samples.sample1", params);
        ProcessInstanceLog log = this.getLogService().findProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)log);
        List tasks = taskService.getTasksOwned("max", "en-UK");
        System.out.println("Found " + tasks.size() + " task(s) for user '" + "max" + "'");
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId, "max");
        taskService.complete(taskId, "max", null);
        tasks = taskService.getTasksAssignedAsPotentialOwner("max", "en-UK");
        System.out.println("Found " + tasks.size() + " task(s) for user '" + "max" + "'");
        taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId, "max");
        taskService.complete(taskId, "max", null);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        System.out.println("Process instance completed");
    }
}

