/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.jbpm;

import java.util.Arrays;
import java.util.Collection;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.spring.jbpm.AbstractJbpmSpringParameterizedTest;

@RunWith(value=Parameterized.class)
public class UserManagedTransactionAuditLogSpringTest
extends AbstractJbpmSpringParameterizedTest {
    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> contextPath() {
        Object[][] data = new Object[][]{{"jbpm/jta-emf/singleton.xml", EmptyContext.get()}, {"jbpm/jta-em/singleton.xml", EmptyContext.get()}};
        return Arrays.asList(data);
    }

    public UserManagedTransactionAuditLogSpringTest(String contextPath, Context<?> runtimeManagerContext) {
        super(contextPath, runtimeManagerContext);
    }

    @Test
    public void testUserTransaction() throws Exception {
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        RuntimeManager manager = this.getManager();
        RuntimeEngine engine = this.getEngine();
        KieSession ksession = this.getKieSession();
        ProcessInstance processInstance = ksession.startProcess("org.jboss.qa.bpms.ScriptTask");
        ProcessInstanceLog instanceLog = this.getLogService().findProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)instanceLog);
        Assert.assertEquals((long)2L, (long)instanceLog.getStatus().intValue());
        ut.commit();
        manager.disposeRuntimeEngine(engine);
    }
}

