/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.tests.annotations;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.spring.beans.annotations.NamedKieBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class NamedInjectionTest {
    static ApplicationContext context = null;

    @BeforeClass
    public static void setup() {
        context = new ClassPathXmlApplicationContext("org/kie/spring/annotations/kie-spring-annotations.xml");
    }

    @Test
    public void testContext() throws Exception {
        Assert.assertNotNull((Object)context);
    }

    @Test
    public void testKieBase() throws Exception {
        KieBase kbase = (KieBase)context.getBean("drl_kiesample3");
        Assert.assertNotNull((Object)kbase);
        NamedKieBean sampleBean = (NamedKieBean)context.getBean("sampleBean");
        Assert.assertNotNull((Object)sampleBean);
        Assert.assertNotNull((Object)sampleBean.getKieBase());
        Assert.assertTrue((boolean)(sampleBean.getKieBase() instanceof KieBase));
    }

    @Test
    public void testSetterKieBase() throws Exception {
        NamedKieBean sampleBean = (NamedKieBean)context.getBean("sampleBean");
        Assert.assertNotNull((Object)sampleBean);
        Assert.assertNotNull((Object)sampleBean.getKieBase2());
        Assert.assertTrue((boolean)(sampleBean.getKieBase2() instanceof KieBase));
    }

    @Test
    public void testStatelessKSessionInjection() throws Exception {
        NamedKieBean sampleBean = (NamedKieBean)context.getBean("sampleBean");
        Assert.assertNotNull((Object)sampleBean);
        Assert.assertNotNull((Object)sampleBean.getKieSession());
        Assert.assertTrue((boolean)(sampleBean.getKieSession() instanceof StatelessKieSession));
    }

    @Test
    public void testStatefulKSessionInjection() throws Exception {
        NamedKieBean sampleBean = (NamedKieBean)context.getBean("sampleBean");
        Assert.assertNotNull((Object)sampleBean);
        Assert.assertNotNull((Object)sampleBean.getStatefulSession());
        Assert.assertTrue((boolean)(sampleBean.getStatefulSession() instanceof KieSession));
    }

    @AfterClass
    public static void tearDown() {
    }
}

