/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.jbpm;

import java.util.Arrays;
import java.util.Collection;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.audit.AuditService;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.spring.jbpm.AbstractJbpmSpringParameterizedTest;

@RunWith(value=Parameterized.class)
public class AuditLogSpringTest
extends AbstractJbpmSpringParameterizedTest {
    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> contextPath() {
        Object[][] data = new Object[][]{{"jbpm/jta-em/singleton.xml", EmptyContext.get()}, {"jbpm/local-em/singleton.xml", EmptyContext.get()}, {"jbpm/jta-emf/singleton.xml", EmptyContext.get()}, {"jbpm/local-emf/singleton.xml", EmptyContext.get()}};
        return Arrays.asList(data);
    }

    public AuditLogSpringTest(String contextPath, Context<?> runtimeManagerContext) {
        super(contextPath, runtimeManagerContext);
    }

    @Test
    public void testAuditLog() throws Exception {
        KieSession ksession = this.getKieSession();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        RuntimeManager manager = this.getManager();
        RuntimeEngine engine = this.getEngine();
        AuditLogService logService = this.getLogService();
        ProcessInstanceLog instanceLog = logService.findProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)instanceLog);
        Assert.assertEquals((long)1L, (long)instanceLog.getStatus().intValue());
        ksession.abortProcessInstance(processInstance.getId());
        instanceLog = logService.findProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)instanceLog);
        Assert.assertEquals((long)3L, (long)instanceLog.getStatus().intValue());
        manager.disposeRuntimeEngine(engine);
    }

    @Test
    public void testAuditLogFromRuntimeEngine() throws Exception {
        KieSession ksession = this.getKieSession();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        RuntimeManager manager = this.getManager();
        RuntimeEngine engine = this.getEngine();
        AuditService logService = engine.getAuditService();
        org.kie.api.runtime.manager.audit.ProcessInstanceLog instanceLog = logService.findProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)instanceLog);
        Assert.assertEquals((long)1L, (long)instanceLog.getStatus().intValue());
        ksession.abortProcessInstance(processInstance.getId());
        instanceLog = logService.findProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)instanceLog);
        Assert.assertEquals((long)3L, (long)instanceLog.getStatus().intValue());
        manager.disposeRuntimeEngine(engine);
    }
}

