/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.jbpm;

import java.util.Arrays;
import java.util.Collection;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.persistence.api.TransactionManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.manager.Context;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.spring.jbpm.AbstractJbpmSpringParameterizedTest;
import org.kie.spring.persistence.KieSpringTransactionManager;
import org.kie.spring.persistence.KieSpringTransactionManagerFactory;
import org.springframework.transaction.jta.JtaTransactionManager;

@RunWith(value=Parameterized.class)
public class KieSpringTransactionManagerFactoryTest
extends AbstractJbpmSpringParameterizedTest {
    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> contextPath() {
        Object[][] data = new Object[][]{{"jbpm/jta-emf/singleton.xml", ProcessInstanceIdContext.get()}};
        return Arrays.asList(data);
    }

    public KieSpringTransactionManagerFactoryTest(String contextPath, Context<?> runtimeManagerContext) {
        super(contextPath, runtimeManagerContext);
    }

    @Test
    public void testTransactionManagerSet() throws Exception {
        Object txManager = this.context.getBean("jbpmTxManager");
        Assert.assertNotNull((Object)txManager);
        Assert.assertTrue((boolean)(txManager instanceof JtaTransactionManager));
        JtaTransactionManager jtaManager = (JtaTransactionManager)txManager;
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.transaction.TransactionManager", (Object)jtaManager);
        KieSpringTransactionManagerFactory factory = new KieSpringTransactionManagerFactory();
        TransactionManager springTxManager = factory.newTransactionManager(env);
        Assert.assertNotNull((Object)springTxManager);
        Assert.assertTrue((boolean)(springTxManager instanceof KieSpringTransactionManager));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTransactionManagerNotSet() throws Exception {
        Object txManager = this.context.getBean("jbpmTxManager");
        Assert.assertNotNull((Object)txManager);
        Assert.assertTrue((boolean)(txManager instanceof JtaTransactionManager));
        JtaTransactionManager jtaManager = (JtaTransactionManager)txManager;
        Environment env = EnvironmentFactory.newEnvironment();
        KieSpringTransactionManagerFactory factory = new KieSpringTransactionManagerFactory();
        TransactionManager springTxManager = factory.newTransactionManager(env);
    }
}

