/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.jbpm.services;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.task.model.Status;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.spring.jbpm.services.AbstractJbpmServicesTest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath*:/jbpm/services/resource-local-services.xml"})
@Rollback(value=true)
@Transactional
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
public class ResourceLocalJbpmServicesTest
extends AbstractJbpmServicesTest {
    @Autowired
    private RuntimeDataService runtimeDataService;
    @Autowired
    private DeploymentService deploymentService;
    @Autowired
    private UserTaskService userTaskService;
    @Autowired
    private ProcessService processService;

    @After
    public void cleanup() {
        this.deploymentService.undeploy((DeploymentUnit)new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT"));
    }

    @Test
    public void testWithPerProcessInstanceStrategy() {
        this.testProcessWithStrategy(RuntimeStrategy.PER_PROCESS_INSTANCE);
    }

    @Test
    public void testWithPerRequestStrategy() {
        this.testProcessWithStrategy(RuntimeStrategy.PER_REQUEST);
    }

    @Test
    public void testWithSingletonStrategy() {
        this.testProcessWithStrategy(RuntimeStrategy.SINGLETON);
    }

    private void testProcessWithStrategy(RuntimeStrategy strategy) {
        KModuleDeploymentUnit deploymentUnit = new KModuleDeploymentUnit("org.jbpm.test", "test-module", "1.0.0-SNAPSHOT");
        deploymentUnit.setStrategy(strategy);
        this.deploymentService.deploy((DeploymentUnit)deploymentUnit);
        String userId = "john";
        Long processInstanceId = this.processService.startProcess(deploymentUnit.getIdentifier(), "hiring");
        List taskIdList = this.runtimeDataService.getTasksByProcessInstanceId(processInstanceId);
        Assertions.assertThat((List)taskIdList).hasSize(1);
        long taskId = (Long)taskIdList.get(0);
        this.userTaskService.claim(Long.valueOf(taskId), userId);
        this.userTaskService.start(Long.valueOf(taskId), userId);
        this.userTaskService.complete(Long.valueOf(taskId), userId, null);
        ArrayList<Status> taskStatus = new ArrayList<Status>();
        taskStatus.add(Status.Completed);
        taskStatus.add(Status.Created);
        taskStatus.add(Status.InProgress);
        taskStatus.add(Status.Reserved);
        List taskSummaryList = this.runtimeDataService.getTasksByStatusByProcessInstanceId(processInstanceId, taskStatus, null);
        Assertions.assertThat((List)taskSummaryList).hasSize(1);
        this.processService.abortProcessInstance(processInstanceId);
        ProcessInstanceDesc pi = this.runtimeDataService.getProcessInstanceById(processInstanceId.longValue());
        Assert.assertNotNull((Object)pi);
        Assert.assertEquals((long)3L, (long)pi.getState().intValue());
    }
}

