/*
 * Decompiled with CFR 0.152.
 */
package org.kie.test.util.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.kie.test.util.filesystem.FileUtils;

public class FileUtilsTest {
    private static final String TEST_FILE = "TestFile.txt";
    private static final String NOTEXISTING_FILE = "NotExisting.txt";

    @Test
    public void getFileExisting() {
        File retrieved = FileUtils.getFile((String)TEST_FILE);
        Assert.assertTrue((boolean)retrieved.exists());
        Assert.assertEquals((Object)TEST_FILE, (Object)retrieved.getName());
    }

    @Test(expected=AssertionError.class)
    public void getFileNotExisting() {
        FileUtils.getFile((String)NOTEXISTING_FILE);
    }

    @Test
    public void getFileInputStreamExisting() throws IOException {
        FileInputStream retrieved = FileUtils.getFileInputStream((String)TEST_FILE);
        Assertions.assertThat((InputStream)retrieved).isNotNull();
        retrieved.close();
    }

    @Test(expected=AssertionError.class)
    public void getFileInputStreamNotExisting() throws IOException {
        FileUtils.getFileInputStream((String)NOTEXISTING_FILE);
    }
}

