/*
 * Decompiled with CFR 0.152.
 */
package org.kie.processmigration.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.quarkus.hibernate.orm.panache.PanacheEntityBase;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.kie.processmigration.model.ProcessRef;

@Entity
@Table(name="plans")
public class Plan
extends PanacheEntityBase {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="planIdSeq")
    @SequenceGenerator(name="planIdSeq", sequenceName="PLAN_ID_SEQ")
    private Long id;
    @NotBlank
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String description;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="containerId", column=@Column(name="source_container_id")), @AttributeOverride(name="processId", column=@Column(name="source_process_id"))})
    @NotNull
    @Valid
    private ProcessRef source;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="containerId", column=@Column(name="target_container_id")), @AttributeOverride(name="processId", column=@Column(name="target_process_id"))})
    @NotNull
    @Valid
    private ProcessRef target;
    @ElementCollection(fetch=FetchType.EAGER)
    @MapKeyColumn(name="source")
    @Column(name="target")
    @CollectionTable(name="plan_mappings", joinColumns={@JoinColumn(name="plan_id")})
    private Map<String, String> mappings = new HashMap<String, String>();

    public Plan copy(Plan plan) {
        this.name = plan.name;
        this.description = plan.description;
        this.source = plan.source;
        this.target = plan.target;
        this.mappings = plan.mappings;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Plan)) {
            return false;
        }
        Plan other = (Plan)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        ProcessRef this$source = this.getSource();
        ProcessRef other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        ProcessRef this$target = this.getTarget();
        ProcessRef other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
            return false;
        }
        Map<String, String> this$mappings = this.getMappings();
        Map<String, String> other$mappings = other.getMappings();
        return !(this$mappings == null ? other$mappings != null : !((Object)this$mappings).equals(other$mappings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Plan;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        ProcessRef $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        ProcessRef $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
        Map<String, String> $mappings = this.getMappings();
        result = result * 59 + ($mappings == null ? 43 : ((Object)$mappings).hashCode());
        return result;
    }

    public String toString() {
        return "Plan(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", source=" + this.getSource() + ", target=" + this.getTarget() + ", mappings=" + this.getMappings() + ")";
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ProcessRef getSource() {
        return this.source;
    }

    public ProcessRef getTarget() {
        return this.target;
    }

    public Map<String, String> getMappings() {
        return this.mappings;
    }

    public Plan setId(Long id) {
        this.id = id;
        return this;
    }

    public Plan setName(String name) {
        this.name = name;
        return this;
    }

    public Plan setDescription(String description) {
        this.description = description;
        return this;
    }

    public Plan setSource(ProcessRef source) {
        this.source = source;
        return this;
    }

    public Plan setTarget(ProcessRef target) {
        this.target = target;
        return this;
    }

    public Plan setMappings(Map<String, String> mappings) {
        this.mappings = mappings;
        return this;
    }
}

