/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.ast.factories;

import java.util.Collections;
import java.util.List;
import org.dmg.pmml.SimplePredicate;
import org.drools.core.util.StringUtils;
import org.kie.pmml.api.enums.BOOLEAN_OPERATOR;
import org.kie.pmml.api.enums.OPERATOR;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.ast.KiePMMLFieldOperatorValue;
import org.kie.pmml.models.drools.ast.factories.KiePMMLAbstractPredicateASTFactory;
import org.kie.pmml.models.drools.ast.factories.KiePMMLSimplePredicateWithAccumulationASTFactory;
import org.kie.pmml.models.drools.ast.factories.KiePMMLSimplePredicateWithResultASTFactory;
import org.kie.pmml.models.drools.ast.factories.PredicateASTFactoryData;
import org.kie.pmml.models.drools.tuples.KiePMMLOperatorValue;
import org.kie.pmml.models.drools.tuples.KiePMMLReasonCodeAndValue;
import org.kie.pmml.models.drools.utils.KiePMMLASTFactoryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLSimplePredicateASTFactory
extends KiePMMLAbstractPredicateASTFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLSimplePredicateASTFactory.class.getName());

    private KiePMMLSimplePredicateASTFactory(PredicateASTFactoryData predicateASTFactoryData) {
        super(predicateASTFactoryData);
    }

    public static KiePMMLSimplePredicateASTFactory factory(PredicateASTFactoryData predicateASTFactoryData) {
        return new KiePMMLSimplePredicateASTFactory(predicateASTFactoryData);
    }

    public void declareRuleFromSimplePredicateSurrogate(String agendaActivationGroup, Number toAccumulate, String statusToSet, KiePMMLReasonCodeAndValue reasonCodeAndValue, boolean isLastCharacteristic) {
        logger.trace("declareRuleFromSimplePredicateSurrogate {} {} {} {}", new Object[]{agendaActivationGroup, toAccumulate, statusToSet, isLastCharacteristic});
        String fieldName = this.predicateASTFactoryData.getFieldTypeMap().get(((SimplePredicate)this.predicateASTFactoryData.getPredicate()).getField().getValue()).getGeneratedType();
        String surrogateCurrentRule = String.format("%s_surrogate_%s", this.predicateASTFactoryData.getCurrentRule(), fieldName);
        List<KiePMMLFieldOperatorValue> constraints = Collections.singletonList(KiePMMLASTFactoryUtils.getConstraintEntryFromSimplePredicates(fieldName, BOOLEAN_OPERATOR.SURROGATE, Collections.singletonList((SimplePredicate)this.predicateASTFactoryData.getPredicate()), this.predicateASTFactoryData.getFieldTypeMap()));
        KiePMMLDroolsRule.Builder builder = this.getBuilderForSimplePredicateSurrogateTrueMatcher(agendaActivationGroup, surrogateCurrentRule, constraints, statusToSet).withAccumulation(toAccumulate);
        if (reasonCodeAndValue != null) {
            builder = builder.withReasonCodeAndValue(reasonCodeAndValue);
        }
        KiePMMLSimplePredicateWithAccumulationASTFactory.declareRuleFromSimplePredicateSurrogateTrueMatcher(builder, this.predicateASTFactoryData.getRules(), isLastCharacteristic);
        builder = this.getBuilderForSimplePredicateSurrogateFalseMatcher(agendaActivationGroup, surrogateCurrentRule, constraints, statusToSet).withAccumulation(toAccumulate);
        if (reasonCodeAndValue != null) {
            builder = builder.withReasonCodeAndValue(reasonCodeAndValue);
        }
        KiePMMLSimplePredicateWithAccumulationASTFactory.declareRuleFromSimplePredicateSurrogateFalseMatcher(builder, this.predicateASTFactoryData.getRules());
    }

    public void declareRuleFromSimplePredicateSurrogate(String agendaActivationGroup, Object result, boolean isFinalLeaf) {
        logger.trace("declareRuleFromSimplePredicateSurrogate {} {} {}", new Object[]{agendaActivationGroup, result, isFinalLeaf});
        String fieldName = this.predicateASTFactoryData.getFieldTypeMap().get(((SimplePredicate)this.predicateASTFactoryData.getPredicate()).getField().getValue()).getGeneratedType();
        String surrogateCurrentRule = String.format("%s_surrogate_%s", this.predicateASTFactoryData.getCurrentRule(), fieldName);
        List<KiePMMLFieldOperatorValue> constraints = Collections.singletonList(KiePMMLASTFactoryUtils.getConstraintEntryFromSimplePredicates(fieldName, BOOLEAN_OPERATOR.SURROGATE, Collections.singletonList((SimplePredicate)this.predicateASTFactoryData.getPredicate()), this.predicateASTFactoryData.getFieldTypeMap()));
        String statusToSet = isFinalLeaf ? "DONE" : this.predicateASTFactoryData.getCurrentRule();
        KiePMMLDroolsRule.Builder builder = this.getBuilderForSimplePredicateSurrogateTrueMatcher(agendaActivationGroup, surrogateCurrentRule, constraints, statusToSet);
        KiePMMLSimplePredicateWithResultASTFactory.declareRuleFromSimplePredicateSurrogateTrueMatcher(builder, this.predicateASTFactoryData.getRules(), result, isFinalLeaf);
        builder = this.getBuilderForSimplePredicateSurrogateFalseMatcher(agendaActivationGroup, surrogateCurrentRule, constraints, statusToSet);
        KiePMMLSimplePredicateWithResultASTFactory.declareRuleFromSimplePredicateSurrogateFalseMatcher(builder, this.predicateASTFactoryData.getRules());
    }

    public void declareRuleFromSimplePredicate(Number toAccumulate, String statusToSet, KiePMMLReasonCodeAndValue reasonCodeAndValue, boolean isLastCharacteristic) {
        logger.trace("declareRuleFromSimplePredicate {} {} {}", new Object[]{toAccumulate, statusToSet, isLastCharacteristic});
        KiePMMLDroolsRule.Builder builder = this.getBuilderForSimplePredicate(statusToSet).withAccumulation(toAccumulate);
        if (reasonCodeAndValue != null) {
            builder = builder.withReasonCodeAndValue(reasonCodeAndValue);
        }
        KiePMMLSimplePredicateWithAccumulationASTFactory.declareRuleFromSimplePredicate(builder, this.predicateASTFactoryData.getRules(), isLastCharacteristic);
    }

    public void declareRuleFromSimplePredicate(Object result, boolean isFinalLeaf) {
        logger.trace("declareRuleFromSimplePredicate {} {}", result, (Object)isFinalLeaf);
        String statusToSet = isFinalLeaf ? "DONE" : this.predicateASTFactoryData.getCurrentRule();
        KiePMMLDroolsRule.Builder builder = this.getBuilderForSimplePredicate(statusToSet);
        KiePMMLSimplePredicateWithResultASTFactory.declareRuleFromSimplePredicate(builder, this.predicateASTFactoryData.getRules(), result, isFinalLeaf);
    }

    private KiePMMLDroolsRule.Builder getBuilderForSimplePredicateSurrogateTrueMatcher(String agendaActivationGroup, String surrogateCurrentRule, List<KiePMMLFieldOperatorValue> constraints, String statusToSet) {
        logger.trace("getBuilderForSimplePredicateSurrogateTrueMatcher {} {} {} {}", new Object[]{agendaActivationGroup, surrogateCurrentRule, constraints, statusToSet});
        return KiePMMLDroolsRule.builder(surrogateCurrentRule + "_TRUE", statusToSet, this.predicateASTFactoryData.getOutputFields()).withAgendaGroup(agendaActivationGroup).withActivationGroup(agendaActivationGroup).withAndConstraints(constraints);
    }

    private KiePMMLDroolsRule.Builder getBuilderForSimplePredicateSurrogateFalseMatcher(String agendaActivationGroup, String surrogateCurrentRule, List<KiePMMLFieldOperatorValue> constraints, String statusToSet) {
        logger.trace("getBuilderForSimplePredicateSurrogateFalseMatcher {} {} {} {}", new Object[]{agendaActivationGroup, surrogateCurrentRule, constraints, statusToSet});
        return KiePMMLDroolsRule.builder(surrogateCurrentRule + "_FALSE", this.predicateASTFactoryData.getParentPath(), this.predicateASTFactoryData.getOutputFields()).withAgendaGroup(agendaActivationGroup).withActivationGroup(agendaActivationGroup).withNotConstraints(constraints);
    }

    protected KiePMMLDroolsRule.Builder getBuilderForSimplePredicate(String statusToSet) {
        logger.trace("getBuilderForSimplePredicate {}", (Object)statusToSet);
        String statusConstraint = StringUtils.isEmpty((CharSequence)this.predicateASTFactoryData.getParentPath()) ? "status == null" : String.format("status == \"%s\"", this.predicateASTFactoryData.getParentPath());
        String key = this.predicateASTFactoryData.getFieldTypeMap().get(((SimplePredicate)this.predicateASTFactoryData.getPredicate()).getField().getValue()).getGeneratedType();
        OPERATOR operator = OPERATOR.byName((String)((SimplePredicate)this.predicateASTFactoryData.getPredicate()).getOperator().value());
        Object value = KiePMMLASTFactoryUtils.getCorrectlyFormattedObject((SimplePredicate)this.predicateASTFactoryData.getPredicate(), this.predicateASTFactoryData.getFieldTypeMap());
        List<KiePMMLFieldOperatorValue> andConstraints = Collections.singletonList(new KiePMMLFieldOperatorValue(key, BOOLEAN_OPERATOR.AND, Collections.singletonList(new KiePMMLOperatorValue(operator, value)), null));
        return KiePMMLDroolsRule.builder(this.predicateASTFactoryData.getCurrentRule(), statusToSet, this.predicateASTFactoryData.getOutputFields()).withStatusConstraint(statusConstraint).withAndConstraints(andConstraints);
    }
}

