/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime.interceptor.check;

import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.SecurityCheck;
import java.lang.reflect.Method;
import java.util.function.Supplier;

public class SupplierRolesAllowedCheck
implements SecurityCheck {
    private final Supplier<String[]> allowedRolesSupplier;
    private volatile String[] allowedRoles;

    public SupplierRolesAllowedCheck(Supplier<String[]> allowedRolesSupplier) {
        this.allowedRolesSupplier = allowedRolesSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void apply(SecurityIdentity identity, Method method, Object[] parameters) {
        String[] stringArray;
        if (this.allowedRoles == null) {
            stringArray = this;
            // MONITORENTER : this
            if (this.allowedRoles == null) {
                this.allowedRoles = this.allowedRolesSupplier.get();
            }
            // MONITOREXIT : stringArray
        }
        stringArray = this.allowedRoles;
        int n = stringArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                if (!identity.isAnonymous()) throw new ForbiddenException();
                throw new UnauthorizedException();
            }
            String role = stringArray[n2];
            if (identity.hasRole(role)) return;
            if ("**".equals(role) && !identity.isAnonymous()) {
                return;
            }
            ++n2;
        }
    }
}

