/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.expressions;

import java.io.Serializable;
import org.kie.pmml.api.enums.CLOSURE;

public class KiePMMLInterval
implements Serializable {
    private static final long serialVersionUID = -5245266051098683475L;
    private final Number leftMargin;
    private final Number rightMargin;
    private final CLOSURE closure;

    public KiePMMLInterval(Number leftMargin, Number rightMargin, CLOSURE closure) {
        this.leftMargin = leftMargin;
        this.rightMargin = rightMargin;
        this.closure = closure;
    }

    public Number getLeftMargin() {
        return this.leftMargin;
    }

    public Number getRightMargin() {
        return this.rightMargin;
    }

    public CLOSURE getClosure() {
        return this.closure;
    }

    public boolean isIn(Number toEvaluate) {
        switch (this.closure) {
            case OPEN_OPEN: {
                return this.isInsideOpenOpen(toEvaluate);
            }
            case OPEN_CLOSED: {
                return this.isInsideOpenClosed(toEvaluate);
            }
            case CLOSED_OPEN: {
                return this.isInsideClosedOpen(toEvaluate);
            }
            case CLOSED_CLOSED: {
                return this.isInsideClosedClosed(toEvaluate);
            }
        }
        throw new IllegalArgumentException("Unexpected closure: " + this.closure);
    }

    boolean isInsideOpenOpen(Number toEvaluate) {
        if (this.leftMargin == null) {
            return toEvaluate.doubleValue() < this.rightMargin.doubleValue();
        }
        if (this.rightMargin == null) {
            return toEvaluate.doubleValue() > this.leftMargin.doubleValue();
        }
        return toEvaluate.doubleValue() > this.leftMargin.doubleValue() && toEvaluate.doubleValue() < this.rightMargin.doubleValue();
    }

    boolean isInsideOpenClosed(Number toEvaluate) {
        if (this.leftMargin == null) {
            return toEvaluate.doubleValue() <= this.rightMargin.doubleValue();
        }
        if (this.rightMargin == null) {
            return toEvaluate.doubleValue() > this.leftMargin.doubleValue();
        }
        return toEvaluate.doubleValue() > this.leftMargin.doubleValue() && toEvaluate.doubleValue() <= this.rightMargin.doubleValue();
    }

    boolean isInsideClosedOpen(Number toEvaluate) {
        if (this.leftMargin == null) {
            return toEvaluate.doubleValue() < this.rightMargin.doubleValue();
        }
        if (this.rightMargin == null) {
            return toEvaluate.doubleValue() >= this.leftMargin.doubleValue();
        }
        return toEvaluate.doubleValue() >= this.leftMargin.doubleValue() && toEvaluate.doubleValue() < this.rightMargin.doubleValue();
    }

    boolean isInsideClosedClosed(Number toEvaluate) {
        if (this.leftMargin == null) {
            return toEvaluate.doubleValue() <= this.rightMargin.doubleValue();
        }
        if (this.rightMargin == null) {
            return toEvaluate.doubleValue() >= this.leftMargin.doubleValue();
        }
        return toEvaluate.doubleValue() >= this.leftMargin.doubleValue() && toEvaluate.doubleValue() <= this.rightMargin.doubleValue();
    }
}

