/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.runtime.ConfigConfig;
import io.quarkus.runtime.LaunchMode;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class ProfileBuildStep {
    @BuildStep
    RunTimeConfigurationDefaultBuildItem defaultProfile(LaunchModeBuildItem launchModeBuildItem) {
        return new RunTimeConfigurationDefaultBuildItem("quarkus.profile", this.getProfileValue(launchModeBuildItem.getLaunchMode()));
    }

    @BuildStep
    void watchProfileSpecificFile(LaunchModeBuildItem launchModeBuildItem, ConfigConfig config, BuildProducer<HotDeploymentWatchedFileBuildItem> items) {
        String activeProfile = this.getProfileValue(launchModeBuildItem.getLaunchMode());
        String suffixedApplicationProperties = String.format("application-%s.properties", activeProfile);
        items.produce(new HotDeploymentWatchedFileBuildItem(suffixedApplicationProperties));
        items.produce(new HotDeploymentWatchedFileBuildItem(Paths.get(String.format(".env-%s", activeProfile), new String[0]).toAbsolutePath().toString()));
        items.produce(new HotDeploymentWatchedFileBuildItem(Paths.get(System.getProperty("user.dir"), "config", suffixedApplicationProperties).toAbsolutePath().toString()));
        if (config.locations.isPresent()) {
            for (String location : (List)config.locations.get()) {
                items.produce(new HotDeploymentWatchedFileBuildItem(this.appendProfileToFilename(location, activeProfile)));
            }
        }
    }

    private String appendProfileToFilename(String path, String activeProfile) {
        String pathWithoutExtension = FilenameUtils.removeExtension((String)path);
        return String.format("%s-%s.%s", pathWithoutExtension, activeProfile, FilenameUtils.getExtension((String)path));
    }

    private String getProfileValue(LaunchMode launchMode) {
        if (launchMode == LaunchMode.DEVELOPMENT) {
            return "dev";
        }
        if (launchMode == LaunchMode.TEST) {
            return "test";
        }
        return "prod";
    }
}

