/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.recovery.arjunacore;

import com.arjuna.ats.internal.jta.recovery.arjunacore.NameScopedElement;
import java.util.Objects;
import javax.transaction.xa.Xid;

class NameScopedXid
implements NameScopedElement {
    private final Xid xid;
    private final String jndiName;

    NameScopedXid(Xid xid, String jndiName) {
        this.xid = xid;
        this.jndiName = jndiName;
    }

    Xid getXid() {
        return this.xid;
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public boolean isSameName(NameScopedElement other) {
        return this.jndiName != null && this.jndiName.equals(other.getJndiName());
    }

    @Override
    public boolean isAnonymous() {
        return this.jndiName == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NameScopedXid scopedXid = (NameScopedXid)o;
        return this.xid.equals(scopedXid.xid) && Objects.equals(this.jndiName, scopedXid.jndiName);
    }

    public int hashCode() {
        return Objects.hash(this.xid, this.jndiName);
    }

    public String toString() {
        return "NameScopedXid{xid=" + this.xid + ", jndiName='" + this.jndiName + '\'' + '}';
    }
}

