/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.deployment;

import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.hibernate.orm.deployment.AdditionalJpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.JpaModelPersistenceUnitMappingBuildItem;
import io.quarkus.hibernate.orm.panache.PanacheEntity;
import io.quarkus.hibernate.orm.panache.PanacheEntityBase;
import io.quarkus.hibernate.orm.panache.PanacheRepository;
import io.quarkus.hibernate.orm.panache.PanacheRepositoryBase;
import io.quarkus.hibernate.orm.panache.deployment.JavaJpaTypeBundle;
import io.quarkus.hibernate.orm.panache.deployment.PanacheEntityClassBuildItem;
import io.quarkus.hibernate.orm.panache.deployment.PanacheJpaRepositoryEnhancer;
import io.quarkus.hibernate.orm.panache.runtime.PanacheHibernateOrmRecorder;
import io.quarkus.panache.common.deployment.HibernateEnhancersRegisteredBuildItem;
import io.quarkus.panache.common.deployment.PanacheJpaEntityOperationsEnhancer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizerBuildItem;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public final class PanacheHibernateResourceProcessor {
    static final DotName DOTNAME_PANACHE_REPOSITORY_BASE = DotName.createSimple((String)PanacheRepositoryBase.class.getName());
    private static final DotName DOTNAME_PANACHE_REPOSITORY = DotName.createSimple((String)PanacheRepository.class.getName());
    static final DotName DOTNAME_PANACHE_ENTITY = DotName.createSimple((String)PanacheEntity.class.getName());
    static final DotName DOTNAME_PANACHE_ENTITY_BASE = DotName.createSimple((String)PanacheEntityBase.class.getName());
    private static final DotName DOTNAME_ENTITY_MANAGER = DotName.createSimple((String)EntityManager.class.getName());
    private static final DotName DOTNAME_ID = DotName.createSimple((String)Id.class.getName());

    @BuildStep
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem(Feature.HIBERNATE_ORM_PANACHE);
    }

    @BuildStep
    AdditionalJpaModelBuildItem produceModel() {
        return new AdditionalJpaModelBuildItem("io.quarkus.hibernate.orm.panache.PanacheEntity");
    }

    @BuildStep
    UnremovableBeanBuildItem ensureBeanLookupAvailable() {
        return new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanTypeExclusion(DOTNAME_ENTITY_MANAGER));
    }

    @BuildStep
    AdditionalApplicationArchiveMarkerBuildItem marker() {
        return new AdditionalApplicationArchiveMarkerBuildItem("META-INF/panache-archive.marker");
    }

    @BuildStep
    void collectEntityClasses(CombinedIndexBuildItem index, BuildProducer<PanacheEntityClassBuildItem> entityClasses) {
        for (ClassInfo panacheEntityBaseSubclass : index.getIndex().getAllKnownSubclasses(DOTNAME_PANACHE_ENTITY_BASE)) {
            if (panacheEntityBaseSubclass.name().equals((Object)DOTNAME_PANACHE_ENTITY)) continue;
            entityClasses.produce((BuildItem)new PanacheEntityClassBuildItem(panacheEntityBaseSubclass));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    @Consume(value=HibernateEnhancersRegisteredBuildItem.class)
    void build(PanacheHibernateOrmRecorder recorder, CombinedIndexBuildItem index, BuildProducer<BytecodeTransformerBuildItem> transformers, List<PanacheEntityClassBuildItem> entityClasses, Optional<JpaModelPersistenceUnitMappingBuildItem> jpaModelPersistenceUnitMapping, List<PanacheMethodCustomizerBuildItem> methodCustomizersBuildItems) {
        List typeParameters;
        List methodCustomizers = methodCustomizersBuildItems.stream().map(PanacheMethodCustomizerBuildItem::getMethodCustomizer).collect(Collectors.toList());
        PanacheJpaRepositoryEnhancer daoEnhancer = new PanacheJpaRepositoryEnhancer(index.getIndex(), JavaJpaTypeBundle.BUNDLE);
        HashSet<String> panacheEntities = new HashSet<String>();
        HashSet<String> daoClasses = new HashSet<String>();
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(DOTNAME_PANACHE_REPOSITORY_BASE)) {
            if (classInfo.name().equals((Object)DOTNAME_PANACHE_REPOSITORY) || daoEnhancer.skipRepository(classInfo)) continue;
            typeParameters = JandexUtil.resolveTypeParameters((DotName)classInfo.name(), (DotName)DOTNAME_PANACHE_REPOSITORY_BASE, (IndexView)index.getIndex());
            panacheEntities.add(((Type)typeParameters.get(0)).name().toString());
            daoClasses.add(classInfo.name().toString());
        }
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(DOTNAME_PANACHE_REPOSITORY)) {
            if (daoEnhancer.skipRepository(classInfo)) continue;
            typeParameters = JandexUtil.resolveTypeParameters((DotName)classInfo.name(), (DotName)DOTNAME_PANACHE_REPOSITORY, (IndexView)index.getIndex());
            panacheEntities.add(((Type)typeParameters.get(0)).name().toString());
            daoClasses.add(classInfo.name().toString());
        }
        for (String daoClass : daoClasses) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(daoClass, (BiFunction)((Object)daoEnhancer)));
        }
        PanacheJpaEntityOperationsEnhancer entityOperationsEnhancer = new PanacheJpaEntityOperationsEnhancer(index.getIndex(), methodCustomizers, JavaJpaTypeBundle.BUNDLE);
        HashSet<String> modelClasses = new HashSet<String>();
        for (PanacheEntityClassBuildItem entityClass : entityClasses) {
            String entityClassName = entityClass.get().name().toString();
            modelClasses.add(entityClassName);
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(true, entityClassName, (BiFunction)entityOperationsEnhancer));
        }
        panacheEntities.addAll(modelClasses);
        this.recordPanacheEntityPersistenceUnits(recorder, jpaModelPersistenceUnitMapping, panacheEntities);
    }

    @BuildStep
    ValidationPhaseBuildItem.ValidationErrorBuildItem validate(ValidationPhaseBuildItem validationPhase, CombinedIndexBuildItem index) throws BuildException {
        for (AnnotationInstance annotationInstance : index.getIndex().getAnnotations(DOTNAME_ID)) {
            ClassInfo info = JandexUtil.getEnclosingClass((AnnotationInstance)annotationInstance);
            if (!JandexUtil.isSubclassOf((IndexView)index.getIndex(), (ClassInfo)info, (DotName)DOTNAME_PANACHE_ENTITY)) continue;
            BuildException be = new BuildException("You provide a JPA identifier via @Id inside '" + info.name() + "' but one is already provided by PanacheEntity, your class should extend PanacheEntityBase instead, or use the id provided by PanacheEntity", Collections.emptyList());
            return new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{be});
        }
        return null;
    }

    void recordPanacheEntityPersistenceUnits(PanacheHibernateOrmRecorder recorder, Optional<JpaModelPersistenceUnitMappingBuildItem> jpaModelPersistenceUnitMapping, Set<String> panacheEntityClasses) {
        HashMap<String, String> panacheEntityToPersistenceUnit = new HashMap<String, String>();
        if (jpaModelPersistenceUnitMapping.isPresent()) {
            Map collectedEntityToPersistenceUnits = jpaModelPersistenceUnitMapping.get().getEntityToPersistenceUnits();
            TreeMap<String, Set> violatingPanacheEntities = new TreeMap<String, Set>();
            for (Map.Entry entry : collectedEntityToPersistenceUnits.entrySet()) {
                String entityName = (String)entry.getKey();
                Set selectedPersistenceUnits = (Set)entry.getValue();
                boolean isPanacheEntity = panacheEntityClasses.contains(entityName);
                if (!isPanacheEntity) continue;
                if (selectedPersistenceUnits.size() == 1) {
                    panacheEntityToPersistenceUnit.put(entityName, (String)selectedPersistenceUnits.iterator().next());
                    continue;
                }
                violatingPanacheEntities.put(entityName, selectedPersistenceUnits);
            }
            if (violatingPanacheEntities.size() > 0) {
                StringBuilder message = new StringBuilder("Panache entities do not support being attached to several persistence units:\n");
                Iterator iterator = violatingPanacheEntities.entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry violatingEntityEntry = iterator.next();
                    message.append("\t- ").append((String)violatingEntityEntry.getKey()).append(" is attached to: ").append(String.join((CharSequence)",", (Iterable)violatingEntityEntry.getValue()));
                    throw new IllegalStateException(message.toString());
                }
            }
        }
        recorder.setEntityToPersistenceUnit(panacheEntityToPersistenceUnit);
    }
}

