/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient;

import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthConfigurations;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.testcontainers.shaded.com.github.dockerjava.core.DockerClientConfig;
import org.testcontainers.shaded.com.github.dockerjava.core.RemoteApiVersion;
import org.testcontainers.shaded.com.github.dockerjava.core.SSLConfig;
import org.testcontainers.utility.AuthConfigUtil;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.RegistryAuthLocator;

class AuthDelegatingDockerClientConfig
implements DockerClientConfig {
    private static final Logger log = LoggerFactory.getLogger(AuthDelegatingDockerClientConfig.class);
    private DockerClientConfig delegate;

    public AuthDelegatingDockerClientConfig(DockerClientConfig delegate) {
        this.delegate = delegate;
    }

    @Override
    public AuthConfig effectiveAuthConfig(String imageName) {
        AuthConfig fallbackAuthConfig;
        try {
            fallbackAuthConfig = this.delegate.effectiveAuthConfig(imageName);
        }
        catch (Exception e) {
            log.debug("Delegate call to effectiveAuthConfig failed with cause: '{}'. Resolution of auth config will continue using RegistryAuthLocator.", (Object)e.getMessage());
            fallbackAuthConfig = new AuthConfig();
        }
        DockerImageName parsed = DockerImageName.parse(imageName);
        AuthConfig effectiveAuthConfig = RegistryAuthLocator.instance().lookupAuthConfig(parsed, fallbackAuthConfig);
        log.debug("Effective auth config [{}]", (Object)AuthConfigUtil.toSafeString(effectiveAuthConfig));
        return effectiveAuthConfig;
    }

    @Override
    public URI getDockerHost() {
        return this.delegate.getDockerHost();
    }

    @Override
    public RemoteApiVersion getApiVersion() {
        return this.delegate.getApiVersion();
    }

    @Override
    public String getRegistryUsername() {
        return this.delegate.getRegistryUsername();
    }

    @Override
    public String getRegistryPassword() {
        return this.delegate.getRegistryPassword();
    }

    @Override
    public String getRegistryEmail() {
        return this.delegate.getRegistryEmail();
    }

    @Override
    public String getRegistryUrl() {
        return this.delegate.getRegistryUrl();
    }

    @Override
    public AuthConfigurations getAuthConfigurations() {
        return this.delegate.getAuthConfigurations();
    }

    @Override
    public SSLConfig getSSLConfig() {
        return this.delegate.getSSLConfig();
    }

    @Override
    public ObjectMapper getObjectMapper() {
        return this.delegate.getObjectMapper();
    }

    private static interface DelegateExclusions {
        public AuthConfig effectiveAuthConfig(String var1);
    }
}

