/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;

public interface ClassFilePostProcessor {
    public byte[] transform(ClassLoader var1, String var2, ProtectionDomain var3, byte[] var4);

    @HashCodeAndEqualsPlugin.Enhance
    public static class ForClassFileTransformer
    implements ClassFilePostProcessor {
        private static final Class<?> UNLOADED_TYPE = null;
        private final ClassFileTransformer classFileTransformer;

        public ForClassFileTransformer(ClassFileTransformer classFileTransformer) {
            this.classFileTransformer = classFileTransformer;
        }

        public byte[] transform(ClassLoader classLoader, String name, ProtectionDomain protectionDomain, byte[] binaryRepresentation) {
            try {
                byte[] transformed = this.classFileTransformer.transform(classLoader, name.replace('.', '/'), UNLOADED_TYPE, protectionDomain, binaryRepresentation);
                return transformed == null ? binaryRepresentation : transformed;
            }
            catch (IllegalClassFormatException exception) {
                throw new IllegalStateException("Failed to transform " + name, exception);
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.classFileTransformer.equals(((ForClassFileTransformer)object).classFileTransformer);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.classFileTransformer.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NoOp implements ClassFilePostProcessor
    {
        INSTANCE;


        @Override
        public byte[] transform(ClassLoader classLoader, String name, ProtectionDomain protectionDomain, byte[] binaryRepresentation) {
            return binaryRepresentation;
        }
    }
}

