/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.api.buildplan.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.buildplan.Port;
import com.google.cloud.tools.jib.configuration.DockerHealthCheck;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.image.json.HistoryEntry;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class Image {
    private final Class<? extends ManifestTemplate> imageFormat;
    @Nullable
    private final Instant created;
    private final String architecture;
    private final String os;
    private final ImmutableList<Layer> layers;
    private final ImmutableList<HistoryEntry> history;
    @Nullable
    private final ImmutableMap<String, String> environment;
    @Nullable
    private final ImmutableList<String> entrypoint;
    @Nullable
    private final ImmutableList<String> programArguments;
    @Nullable
    private final DockerHealthCheck healthCheck;
    @Nullable
    private final ImmutableSet<Port> exposedPorts;
    @Nullable
    private final ImmutableSet<AbsoluteUnixPath> volumes;
    @Nullable
    private final ImmutableMap<String, String> labels;
    @Nullable
    private final String workingDirectory;
    @Nullable
    private final String user;

    public static Builder builder(Class<? extends ManifestTemplate> imageFormat) {
        return new Builder(imageFormat);
    }

    private Image(Class<? extends ManifestTemplate> imageFormat, @Nullable Instant created, String architecture, String os, ImmutableList<Layer> layers, ImmutableList<HistoryEntry> history, @Nullable ImmutableMap<String, String> environment, @Nullable ImmutableList<String> entrypoint, @Nullable ImmutableList<String> programArguments, @Nullable DockerHealthCheck healthCheck, @Nullable ImmutableSet<Port> exposedPorts, @Nullable ImmutableSet<AbsoluteUnixPath> volumes, @Nullable ImmutableMap<String, String> labels, @Nullable String workingDirectory, @Nullable String user) {
        this.imageFormat = imageFormat;
        this.created = created;
        this.architecture = architecture;
        this.os = os;
        this.layers = layers;
        this.history = history;
        this.environment = environment;
        this.entrypoint = entrypoint;
        this.programArguments = programArguments;
        this.healthCheck = healthCheck;
        this.exposedPorts = exposedPorts;
        this.volumes = volumes;
        this.labels = labels;
        this.workingDirectory = workingDirectory;
        this.user = user;
    }

    public Class<? extends ManifestTemplate> getImageFormat() {
        return this.imageFormat;
    }

    @Nullable
    public Instant getCreated() {
        return this.created;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getOs() {
        return this.os;
    }

    @Nullable
    public ImmutableMap<String, String> getEnvironment() {
        return this.environment;
    }

    @Nullable
    public ImmutableList<String> getEntrypoint() {
        return this.entrypoint;
    }

    @Nullable
    public ImmutableList<String> getProgramArguments() {
        return this.programArguments;
    }

    @Nullable
    public DockerHealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    @Nullable
    public ImmutableSet<Port> getExposedPorts() {
        return this.exposedPorts;
    }

    @Nullable
    public ImmutableSet<AbsoluteUnixPath> getVolumes() {
        return this.volumes;
    }

    @Nullable
    public ImmutableMap<String, String> getLabels() {
        return this.labels;
    }

    @Nullable
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Nullable
    public String getUser() {
        return this.user;
    }

    public ImmutableList<Layer> getLayers() {
        return this.layers;
    }

    public ImmutableList<HistoryEntry> getHistory() {
        return this.history;
    }

    public static class Builder {
        private final Class<? extends ManifestTemplate> imageFormat;
        private final ImmutableList.Builder<Layer> imageLayersBuilder = ImmutableList.builder();
        private final ImmutableList.Builder<HistoryEntry> historyBuilder = ImmutableList.builder();
        private final Map<String, String> environmentBuilder = new HashMap<String, String>();
        private final Map<String, String> labelsBuilder = new HashMap<String, String>();
        private final Set<Port> exposedPortsBuilder = new HashSet<Port>();
        private final Set<AbsoluteUnixPath> volumesBuilder = new HashSet<AbsoluteUnixPath>();
        @Nullable
        private Instant created;
        private String architecture = "amd64";
        private String os = "linux";
        @Nullable
        private ImmutableList<String> entrypoint;
        @Nullable
        private ImmutableList<String> programArguments;
        @Nullable
        private DockerHealthCheck healthCheck;
        @Nullable
        private String workingDirectory;
        @Nullable
        private String user;

        private Builder(Class<? extends ManifestTemplate> imageFormat) {
            this.imageFormat = imageFormat;
        }

        public Builder setCreated(Instant created) {
            this.created = created;
            return this;
        }

        public Builder setArchitecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public Builder setOs(String os) {
            this.os = os;
            return this;
        }

        public Builder addEnvironment(@Nullable Map<String, String> environment) {
            if (environment != null) {
                this.environmentBuilder.putAll(environment);
            }
            return this;
        }

        public Builder addEnvironmentVariable(String name, String value) {
            this.environmentBuilder.put(name, value);
            return this;
        }

        public Builder setEntrypoint(@Nullable List<String> entrypoint) {
            this.entrypoint = entrypoint == null ? null : ImmutableList.copyOf(entrypoint);
            return this;
        }

        public Builder setUser(@Nullable String user) {
            this.user = user;
            return this;
        }

        public Builder setProgramArguments(@Nullable List<String> programArguments) {
            this.programArguments = programArguments == null ? null : ImmutableList.copyOf(programArguments);
            return this;
        }

        public Builder setHealthCheck(@Nullable DockerHealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public Builder addExposedPorts(@Nullable Set<Port> exposedPorts) {
            if (exposedPorts != null) {
                this.exposedPortsBuilder.addAll(exposedPorts);
            }
            return this;
        }

        public Builder addVolumes(@Nullable Set<AbsoluteUnixPath> volumes) {
            if (volumes != null) {
                this.volumesBuilder.addAll((Collection<AbsoluteUnixPath>)ImmutableSet.copyOf(volumes));
            }
            return this;
        }

        public Builder addLabels(@Nullable Map<String, String> labels) {
            if (labels != null) {
                this.labelsBuilder.putAll(labels);
            }
            return this;
        }

        public Builder addLabel(String name, String value) {
            this.labelsBuilder.put(name, value);
            return this;
        }

        public Builder setWorkingDirectory(@Nullable String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public Builder addLayer(Layer layer) throws LayerPropertyNotFoundException {
            this.imageLayersBuilder.add((Object)layer);
            return this;
        }

        public Builder addHistory(HistoryEntry history) {
            this.historyBuilder.add((Object)history);
            return this;
        }

        public Image build() {
            return new Image(this.imageFormat, this.created, this.architecture, this.os, this.imageLayersBuilder.build(), this.historyBuilder.build(), ImmutableMap.copyOf(this.environmentBuilder), this.entrypoint, this.programArguments, this.healthCheck, ImmutableSet.copyOf(this.exposedPortsBuilder), ImmutableSet.copyOf(this.volumesBuilder), ImmutableMap.copyOf(this.labelsBuilder), this.workingDirectory, this.user);
        }
    }
}

