/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.devconsole;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.hibernate.LockOptions;
import org.hibernate.boot.Metadata;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;
import org.hibernate.tool.schema.internal.exec.ScriptTargetOutputToWriter;
import org.hibernate.tool.schema.spi.ScriptTargetOutput;
import org.hibernate.tool.schema.spi.TargetDescriptor;

public class HibernateOrmDevConsoleInfoSupplier
implements Supplier<PersistenceUnitsInfo> {
    private static final String DEFAULT = "<default>";
    private static final PersistenceUnitsInfo INSTANCE = new PersistenceUnitsInfo();

    public static void pushPersistenceUnit(String persistenceUnitName, Metadata metadata, ServiceRegistry serviceRegistry, String importFile) {
        List list;
        HibernateOrmDevConsoleInfoSupplier.INSTANCE.persistenceUnits.add(persistenceUnitName);
        String createSchema = HibernateOrmDevConsoleInfoSupplier.generateDDL(SchemaExport.Action.CREATE, metadata, serviceRegistry, importFile);
        HibernateOrmDevConsoleInfoSupplier.INSTANCE.createDDLs.put(persistenceUnitName, createSchema);
        String dropSchema = HibernateOrmDevConsoleInfoSupplier.generateDDL(SchemaExport.Action.DROP, metadata, serviceRegistry, importFile);
        HibernateOrmDevConsoleInfoSupplier.INSTANCE.dropDDLs.put(persistenceUnitName, dropSchema);
        for (PersistentClass entityBinding : metadata.getEntityBindings()) {
            list = HibernateOrmDevConsoleInfoSupplier.INSTANCE.managedEntities.computeIfAbsent(persistenceUnitName, pu -> new ArrayList());
            list.add(new EntityInfo(entityBinding.getClassName(), entityBinding.getTable().getName(), persistenceUnitName));
        }
        for (NamedQueryDefinition queryDefinition : metadata.getNamedQueryDefinitions()) {
            list = HibernateOrmDevConsoleInfoSupplier.INSTANCE.namedQueries.computeIfAbsent(persistenceUnitName, pu -> new ArrayList());
            list.add(new QueryInfo(queryDefinition));
        }
        for (NamedSQLQueryDefinition staticQueryDefinition : metadata.getNamedNativeQueryDefinitions()) {
            list = HibernateOrmDevConsoleInfoSupplier.INSTANCE.namedNativeQueries.computeIfAbsent(persistenceUnitName, pu -> new ArrayList());
            list.add(new QueryInfo((NamedQueryDefinition)staticQueryDefinition));
        }
    }

    private static String generateDDL(SchemaExport.Action action, Metadata metadata, ServiceRegistry serviceRegistry, String importFiles) {
        SchemaExport schemaExport = new SchemaExport();
        schemaExport.setFormat(true);
        schemaExport.setDelimiter(";");
        schemaExport.setImportFiles(importFiles);
        final StringWriter writer = new StringWriter();
        schemaExport.doExecution(action, false, metadata, serviceRegistry, new TargetDescriptor(){

            public EnumSet<TargetType> getTargetTypes() {
                return EnumSet.of(TargetType.SCRIPT);
            }

            public ScriptTargetOutput getScriptTargetOutput() {
                return new ScriptTargetOutputToWriter(writer){

                    public void accept(String command) {
                        super.accept(command);
                    }
                };
            }
        });
        return writer.toString();
    }

    @Override
    public PersistenceUnitsInfo get() {
        return INSTANCE;
    }

    static class PersistenceUnitNameComparator
    implements Comparator<String> {
        PersistenceUnitNameComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (HibernateOrmDevConsoleInfoSupplier.DEFAULT.equals(o1)) {
                return -1;
            }
            if (HibernateOrmDevConsoleInfoSupplier.DEFAULT.equals(o2)) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }

    public static class QueryInfo {
        private final String name;
        private final String query;
        private final boolean cacheable;
        private final String lockMode;
        private final String type;

        public QueryInfo(NamedQueryDefinition queryDefinition) {
            this.name = queryDefinition.getName();
            this.query = queryDefinition.getQuery();
            this.cacheable = queryDefinition.isCacheable();
            LockOptions lockOptions = queryDefinition.getLockOptions();
            this.lockMode = lockOptions != null && lockOptions.getLockMode() != null ? lockOptions.getLockMode().name() : "";
            this.type = queryDefinition instanceof NamedSQLQueryDefinition ? "native" : "JPQL";
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query;
        }

        public boolean isCacheable() {
            return this.cacheable;
        }

        public String getLockMode() {
            return this.lockMode;
        }

        public String getType() {
            return this.type;
        }
    }

    public static class EntityInfo {
        private final String className;
        private final String tableName;
        private final String persistenceUnitName;

        public EntityInfo(String className, String tableName, String persistenceUnitName) {
            this.className = className;
            this.tableName = tableName;
            this.persistenceUnitName = persistenceUnitName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getPersistenceUnitName() {
            return this.persistenceUnitName;
        }
    }

    public static class PersistenceUnitsInfo {
        private final List<String> persistenceUnits = Collections.synchronizedList(new ArrayList());
        private final Map<String, List<EntityInfo>> managedEntities = new ConcurrentHashMap<String, List<EntityInfo>>();
        private final Map<String, List<QueryInfo>> namedQueries = new ConcurrentHashMap<String, List<QueryInfo>>();
        private final Map<String, List<QueryInfo>> namedNativeQueries = new ConcurrentHashMap<String, List<QueryInfo>>();
        private final Map<String, String> createDDLs = new ConcurrentHashMap<String, String>();
        private final Map<String, String> dropDDLs = new ConcurrentHashMap<String, String>();
        private boolean sorted;

        public List<String> getPersistenceUnits() {
            if (!this.sorted) {
                this.sorted = true;
                this.persistenceUnits.sort(new PersistenceUnitNameComparator());
            }
            return this.persistenceUnits;
        }

        public Map<String, String> getCreateDDLs() {
            return this.createDDLs;
        }

        public Map<String, String> getDropDDLs() {
            return this.dropDDLs;
        }

        public List<EntityInfo> getManagedEntities(String pu) {
            return this.managedEntities.getOrDefault(pu, Collections.emptyList());
        }

        public List<QueryInfo> getNamedQueries(String pu) {
            return this.namedQueries.getOrDefault(pu, Collections.emptyList());
        }

        public List<QueryInfo> getNamedNativeQueries(String pu) {
            return this.namedNativeQueries.getOrDefault(pu, Collections.emptyList());
        }

        public List<QueryInfo> getAllNamedQueries(String pu) {
            ArrayList<QueryInfo> allQueries = new ArrayList<QueryInfo>();
            allQueries.addAll(this.namedQueries.getOrDefault(pu, Collections.emptyList()));
            allQueries.addAll(this.namedNativeQueries.getOrDefault(pu, Collections.emptyList()));
            return allQueries;
        }

        public int getNumberOfNamedQueries() {
            return this.namedQueries.values().stream().mapToInt(List::size).reduce(Integer::sum).orElse(0) + this.namedNativeQueries.values().stream().mapToInt(List::size).reduce(Integer::sum).orElse(0);
        }

        public int getNumberOfEntities() {
            return this.managedEntities.values().stream().mapToInt(List::size).reduce(Integer::sum).orElse(0);
        }
    }
}

