/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jdbc.oracle.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.RemovedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ExcludeConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageAllowIncompleteClasspathBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.maven.dependency.GACT;
import java.util.Collections;

public final class OracleMetadataOverrides {
    static final String DRIVER_JAR_MATCH_REGEX = ".*com\\.oracle\\.database\\.jdbc.*";
    static final String NATIVE_IMAGE_RESOURCE_MATCH_REGEX = "/META-INF/native-image/(?:native-image\\.properties|reflect-config\\.json)";

    @BuildStep
    void build(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, new String[]{"oracle.jdbc.internal.ACProxyable"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{"oracle.jdbc.driver.T4CDriverExtension"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{"oracle.jdbc.driver.T2CDriverExtension"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{"oracle.jdbc.driver.ShardingDriverExtension"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{"oracle.net.ano.Ano"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{"oracle.net.ano.AuthenticationService"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{"oracle.net.ano.DataIntegrityService"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{"oracle.net.ano.EncryptionService"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{"oracle.net.ano.SupervisorService"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{"oracle.jdbc.driver.Message11"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, true, new String[]{"oracle.sql.TypeDescriptor"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{"oracle.sql.TypeDescriptorFactory"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{"oracle.sql.AnyDataFactory"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{"com.sun.rowset.providers.RIOptimisticProvider"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, new String[]{"oracle.jdbc.logging.annotations.Supports"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, new String[]{"oracle.jdbc.logging.annotations.Feature"}));
    }

    @BuildStep
    void runtimeInitializeDriver(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitialized) {
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("oracle.jdbc.driver.LogicalConnection"));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("oracle.jdbc.pool.OraclePooledConnection"));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("oracle.jdbc.pool.OracleDataSource"));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("oracle.jdbc.datasource.impl.OracleDataSource"));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("oracle.jdbc.pool.OracleOCIConnectionPool"));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("oracle.jdbc.driver.OracleTimeoutThreadPerVM"));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("oracle.net.nt.TimeoutInterruptHandler"));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("oracle.jdbc.driver.HAManager"));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("oracle.net.nt.Clock"));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("oracle.net.nt.TcpMultiplexer"));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("oracle.net.nt.TcpMultiplexer"));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("oracle.net.nt.TcpMultiplexer$LazyHolder"));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("oracle.jdbc.driver.BlockSource$ThreadedCachingBlockSource"));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("oracle.jdbc.driver.BlockSource$ThreadedCachingBlockSource$BlockReleaser"));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("oracle.jdbc.xa.client.OracleXADataSource"));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("oracle.jdbc.replay.OracleXADataSourceImpl"));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("oracle.jdbc.datasource.OracleXAConnection"));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("oracle.jdbc.xa.client.OracleXAConnection"));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("oracle.jdbc.xa.client.OracleXAHeteroConnection"));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("oracle.jdbc.driver.T4CXAConnection"));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("oracle.security.o5logon.O5Logon"));
    }

    @BuildStep
    ExcludeConfigBuildItem excludeOracleDirectives() {
        return new ExcludeConfigBuildItem(DRIVER_JAR_MATCH_REGEX, NATIVE_IMAGE_RESOURCE_MATCH_REGEX);
    }

    @BuildStep
    NativeImageAllowIncompleteClasspathBuildItem naughtyDriver() {
        return new NativeImageAllowIncompleteClasspathBuildItem("quarkus-jdbc-oracle");
    }

    @BuildStep
    RemovedResourceBuildItem overrideSubstitutions() {
        return new RemovedResourceBuildItem(GACT.fromString((String)"com.oracle.database.jdbc:ojdbc11"), Collections.singleton("oracle/nativeimage/Target_java_io_ObjectStreamClass.class"));
    }

    @BuildStep
    RemovedResourceBuildItem enhancedCharsetSubstitutions() {
        return new RemovedResourceBuildItem(GACT.fromString((String)"com.oracle.database.jdbc:ojdbc11"), Collections.singleton("oracle/nativeimage/CharacterSetFeature.class"));
    }
}

