/*
 * Decompiled with CFR 0.152.
 */
package org.kie.processmigration.model;

import io.quarkus.hibernate.orm.panache.PanacheEntityBase;
import io.quarkus.hibernate.orm.panache.PanacheQuery;
import io.quarkus.hibernate.orm.panache.runtime.JpaOperations;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.LockModeType;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExtendedSelfDirtinessTracker;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.kie.server.api.model.admin.MigrationReportInstance;

@Entity
@Table(name="migration_reports", indexes={@Index(columnList="migration_id")})
public class MigrationReport
extends PanacheEntityBase
implements ManagedEntity,
PersistentAttributeInterceptable,
ExtendedSelfDirtinessTracker {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="migRepIdSeq")
    @SequenceGenerator(name="migRepIdSeq", sequenceName="MIG_REP_ID_SEQ")
    private Long id;
    @Column(name="migration_id")
    private Long migrationId;
    @Column(name="process_instance_id")
    private Long processInstanceId;
    @Column(name="start_date")
    private Instant startDate;
    @Column(name="end_date")
    private Instant endDate;
    @Column(name="success")
    private Boolean successful;
    @ElementCollection(fetch=FetchType.EAGER)
    @Column(name="log")
    @Lob
    @CollectionTable(name="migration_report_logs", joinColumns={@JoinColumn(name="report_id")})
    private List<String> logs;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;
    @Transient
    private transient CollectionTracker $$_hibernate_collectionTracker;

    public MigrationReport() {
    }

    public MigrationReport(Long migrationId, MigrationReportInstance reportInstance) {
        this.$$_hibernate_write_migrationId(migrationId);
        this.$$_hibernate_write_processInstanceId(reportInstance.getProcessInstanceId());
        if (reportInstance.getStartDate() != null) {
            this.$$_hibernate_write_startDate(reportInstance.getStartDate().toInstant());
        }
        if (reportInstance.getEndDate() != null) {
            this.$$_hibernate_write_endDate(reportInstance.getEndDate().toInstant());
        }
        this.$$_hibernate_write_successful(reportInstance.isSuccessful());
        this.$$_hibernate_write_logs(new ArrayList(reportInstance.getLogs()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MigrationReport)) {
            return false;
        }
        MigrationReport other = (MigrationReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$migrationId = this.getMigrationId();
        Long other$migrationId = other.getMigrationId();
        if (this$migrationId == null ? other$migrationId != null : !((Object)this$migrationId).equals(other$migrationId)) {
            return false;
        }
        Long this$processInstanceId = this.getProcessInstanceId();
        Long other$processInstanceId = other.getProcessInstanceId();
        if (this$processInstanceId == null ? other$processInstanceId != null : !((Object)this$processInstanceId).equals(other$processInstanceId)) {
            return false;
        }
        Boolean this$successful = this.getSuccessful();
        Boolean other$successful = other.getSuccessful();
        if (this$successful == null ? other$successful != null : !((Object)this$successful).equals(other$successful)) {
            return false;
        }
        Instant this$startDate = this.getStartDate();
        Instant other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Instant this$endDate = this.getEndDate();
        Instant other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        List<String> this$logs = this.getLogs();
        List<String> other$logs = other.getLogs();
        return !(this$logs == null ? other$logs != null : !((Object)this$logs).equals(other$logs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MigrationReport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $migrationId = this.getMigrationId();
        result = result * 59 + ($migrationId == null ? 43 : ((Object)$migrationId).hashCode());
        Long $processInstanceId = this.getProcessInstanceId();
        result = result * 59 + ($processInstanceId == null ? 43 : ((Object)$processInstanceId).hashCode());
        Boolean $successful = this.getSuccessful();
        result = result * 59 + ($successful == null ? 43 : ((Object)$successful).hashCode());
        Instant $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Instant $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        List<String> $logs = this.getLogs();
        result = result * 59 + ($logs == null ? 43 : ((Object)$logs).hashCode());
        return result;
    }

    public String toString() {
        return "MigrationReport(id=" + this.getId() + ", migrationId=" + this.getMigrationId() + ", processInstanceId=" + this.getProcessInstanceId() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", successful=" + this.getSuccessful() + ", logs=" + this.getLogs() + ")";
    }

    public Long getId() {
        return this.$$_hibernate_read_id();
    }

    public Long getMigrationId() {
        return this.$$_hibernate_read_migrationId();
    }

    public Long getProcessInstanceId() {
        return this.$$_hibernate_read_processInstanceId();
    }

    public Instant getStartDate() {
        return this.$$_hibernate_read_startDate();
    }

    public Instant getEndDate() {
        return this.$$_hibernate_read_endDate();
    }

    public Boolean getSuccessful() {
        return this.$$_hibernate_read_successful();
    }

    public List<String> getLogs() {
        return this.$$_hibernate_read_logs();
    }

    public MigrationReport setId(Long id) {
        this.$$_hibernate_write_id(id);
        return this;
    }

    public MigrationReport setMigrationId(Long migrationId) {
        this.$$_hibernate_write_migrationId(migrationId);
        return this;
    }

    public MigrationReport setProcessInstanceId(Long processInstanceId) {
        this.$$_hibernate_write_processInstanceId(processInstanceId);
        return this;
    }

    public MigrationReport setStartDate(Instant startDate) {
        this.$$_hibernate_write_startDate(startDate);
        return this;
    }

    public MigrationReport setEndDate(Instant endDate) {
        this.$$_hibernate_write_endDate(endDate);
        return this;
    }

    public MigrationReport setSuccessful(Boolean successful) {
        this.$$_hibernate_write_successful(successful);
        return this;
    }

    public MigrationReport setLogs(List<String> logs) {
        this.$$_hibernate_write_logs(logs);
        return this;
    }

    public static /* synthetic */ long count() {
        return JpaOperations.INSTANCE.count(MigrationReport.class);
    }

    public static /* synthetic */ long count(String string, Object[] objectArray) {
        return JpaOperations.INSTANCE.count(MigrationReport.class, string, objectArray);
    }

    public static /* synthetic */ long count(String string, Parameters parameters) {
        return JpaOperations.INSTANCE.count(MigrationReport.class, string, parameters);
    }

    public static /* synthetic */ long count(String string, Map<String, Object> map) {
        return JpaOperations.INSTANCE.count(MigrationReport.class, string, map);
    }

    public static /* synthetic */ long delete(String string, Object[] objectArray) {
        return JpaOperations.INSTANCE.delete(MigrationReport.class, string, objectArray);
    }

    public static /* synthetic */ long delete(String string, Parameters parameters) {
        return JpaOperations.INSTANCE.delete(MigrationReport.class, string, parameters);
    }

    public static /* synthetic */ long delete(String string, Map<String, Object> map) {
        return JpaOperations.INSTANCE.delete(MigrationReport.class, string, map);
    }

    public static /* synthetic */ long deleteAll() {
        return JpaOperations.INSTANCE.deleteAll(MigrationReport.class);
    }

    public static /* synthetic */ boolean deleteById(Object object) {
        return JpaOperations.INSTANCE.deleteById(MigrationReport.class, object);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> PanacheQuery<T> find(String string, Object[] objectArray) {
        return (PanacheQuery)JpaOperations.INSTANCE.find(MigrationReport.class, string, objectArray);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> PanacheQuery<T> find(String string, Parameters parameters) {
        return (PanacheQuery)JpaOperations.INSTANCE.find(MigrationReport.class, string, parameters);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> PanacheQuery<T> find(String string, Sort sort, Object[] objectArray) {
        return (PanacheQuery)JpaOperations.INSTANCE.find(MigrationReport.class, string, sort, objectArray);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> PanacheQuery<T> find(String string, Sort sort, Parameters parameters) {
        return (PanacheQuery)JpaOperations.INSTANCE.find(MigrationReport.class, string, sort, parameters);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> PanacheQuery<T> find(String string, Sort sort, Map<String, Object> map) {
        return (PanacheQuery)JpaOperations.INSTANCE.find(MigrationReport.class, string, sort, map);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> PanacheQuery<T> find(String string, Map<String, Object> map) {
        return (PanacheQuery)JpaOperations.INSTANCE.find(MigrationReport.class, string, map);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> PanacheQuery<T> findAll() {
        return (PanacheQuery)JpaOperations.INSTANCE.findAll(MigrationReport.class);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> PanacheQuery<T> findAll(Sort sort) {
        return (PanacheQuery)JpaOperations.INSTANCE.findAll(MigrationReport.class, sort);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> T findById(Object object) {
        return (T)((PanacheEntityBase)JpaOperations.INSTANCE.findById(MigrationReport.class, object));
    }

    public static /* synthetic */ <T extends PanacheEntityBase> T findById(Object object, LockModeType lockModeType) {
        return (T)((PanacheEntityBase)JpaOperations.INSTANCE.findById(MigrationReport.class, object, lockModeType));
    }

    public static /* synthetic */ <T extends PanacheEntityBase> Optional<T> findByIdOptional(Object object) {
        return JpaOperations.INSTANCE.findByIdOptional(MigrationReport.class, object);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> Optional<T> findByIdOptional(Object object, LockModeType lockModeType) {
        return JpaOperations.INSTANCE.findByIdOptional(MigrationReport.class, object, lockModeType);
    }

    public static /* synthetic */ void flush() {
        JpaOperations.INSTANCE.flush(MigrationReport.class);
    }

    public static /* synthetic */ EntityManager getEntityManager() {
        return JpaOperations.INSTANCE.getEntityManager(MigrationReport.class);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> List<T> list(String string, Object[] objectArray) {
        return JpaOperations.INSTANCE.list(MigrationReport.class, string, objectArray);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> List<T> list(String string, Parameters parameters) {
        return JpaOperations.INSTANCE.list(MigrationReport.class, string, parameters);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> List<T> list(String string, Sort sort, Object[] objectArray) {
        return JpaOperations.INSTANCE.list(MigrationReport.class, string, sort, objectArray);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> List<T> list(String string, Sort sort, Parameters parameters) {
        return JpaOperations.INSTANCE.list(MigrationReport.class, string, sort, parameters);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> List<T> list(String string, Sort sort, Map<String, Object> map) {
        return JpaOperations.INSTANCE.list(MigrationReport.class, string, sort, map);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> List<T> list(String string, Map<String, Object> map) {
        return JpaOperations.INSTANCE.list(MigrationReport.class, string, map);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> List<T> listAll() {
        return JpaOperations.INSTANCE.listAll(MigrationReport.class);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> List<T> listAll(Sort sort) {
        return JpaOperations.INSTANCE.listAll(MigrationReport.class, sort);
    }

    public static /* synthetic */ void persist(Iterable<?> iterable) {
        PanacheEntityBase.persist(iterable);
    }

    public static /* synthetic */ void persist(Object object, Object[] objectArray) {
        PanacheEntityBase.persist(object, objectArray);
    }

    public static /* synthetic */ void persist(Stream<?> stream) {
        PanacheEntityBase.persist(stream);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> Stream<T> stream(String string, Object[] objectArray) {
        return JpaOperations.INSTANCE.stream(MigrationReport.class, string, objectArray);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> Stream<T> stream(String string, Parameters parameters) {
        return JpaOperations.INSTANCE.stream(MigrationReport.class, string, parameters);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> Stream<T> stream(String string, Sort sort, Object[] objectArray) {
        return JpaOperations.INSTANCE.stream(MigrationReport.class, string, sort, objectArray);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> Stream<T> stream(String string, Sort sort, Parameters parameters) {
        return JpaOperations.INSTANCE.stream(MigrationReport.class, string, sort, parameters);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> Stream<T> stream(String string, Sort sort, Map<String, Object> map) {
        return JpaOperations.INSTANCE.stream(MigrationReport.class, string, sort, map);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> Stream<T> stream(String string, Map<String, Object> map) {
        return JpaOperations.INSTANCE.stream(MigrationReport.class, string, map);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> Stream<T> streamAll() {
        return JpaOperations.INSTANCE.streamAll(MigrationReport.class);
    }

    public static /* synthetic */ <T extends PanacheEntityBase> Stream<T> streamAll(Sort sort) {
        return JpaOperations.INSTANCE.streamAll(MigrationReport.class, sort);
    }

    public static /* synthetic */ int update(String string, Object[] objectArray) {
        return JpaOperations.INSTANCE.update(MigrationReport.class, string, objectArray);
    }

    public static /* synthetic */ int update(String string, Parameters parameters) {
        return JpaOperations.INSTANCE.update(MigrationReport.class, string, parameters);
    }

    public static /* synthetic */ int update(String string, Map<String, Object> map) {
        return JpaOperations.INSTANCE.update(MigrationReport.class, string, map);
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        if (this.$$_hibernate_collectionTracker == null) {
            stringArray = this.$$_hibernate_tracker == null ? new String[]{} : this.$$_hibernate_tracker.get();
        } else {
            if (this.$$_hibernate_tracker == null) {
                this.$$_hibernate_tracker = new SimpleFieldTracker();
            }
            this.$$_hibernate_getCollectionFieldDirtyNames(this.$$_hibernate_tracker);
            stringArray = this.$$_hibernate_tracker.get();
        }
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        MigrationReport migrationReport = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty() || this.$$_hibernate_areCollectionFieldsDirty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
        this.$$_hibernate_clearDirtyCollectionNames();
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        return this.$$_hibernate_collectionTracker;
    }

    public boolean $$_hibernate_areCollectionFieldsDirty() {
        boolean bl;
        block0: {
            int n;
            block1: {
                MigrationReport migrationReport = this;
                bl = false;
                if (bl || this.$$_hibernate_collectionTracker == null) break block0;
                n = this.$$_hibernate_collectionTracker.getSize("logs");
                if (this.logs != null || n == -1) break block1;
                bl = true;
                break block0;
            }
            if (this.logs == null || this.logs instanceof PersistentCollection && !((PersistentCollection)this.logs).wasInitialized() || n == this.logs.size()) break block0;
            bl = true;
        }
        return bl;
    }

    public void $$_hibernate_getCollectionFieldDirtyNames(DirtyTracker dirtyTracker) {
        block0: {
            int n;
            block1: {
                MigrationReport migrationReport = this;
                DirtyTracker dirtyTracker2 = dirtyTracker;
                if (this.$$_hibernate_collectionTracker == null) break block0;
                n = this.$$_hibernate_collectionTracker.getSize("logs");
                if (this.logs != null || n == -1) break block1;
                dirtyTracker.add("logs");
                break block0;
            }
            if (this.logs == null || this.logs instanceof PersistentCollection && !((PersistentCollection)this.logs).wasInitialized() || n == this.logs.size()) break block0;
            dirtyTracker.add("logs");
        }
    }

    public void $$_hibernate_clearDirtyCollectionNames() {
        if (this.$$_hibernate_collectionTracker == null) {
            this.$$_hibernate_collectionTracker = new SimpleCollectionTracker();
        }
        this.$$_hibernate_removeDirtyFields(null);
    }

    public void $$_hibernate_removeDirtyFields(LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor) {
        block3: {
            if (this.$$_hibernate_attributeInterceptor instanceof LazyAttributeLoadingInterceptor) {
                lazyAttributeLoadingInterceptor = (LazyAttributeLoadingInterceptor)this.$$_hibernate_attributeInterceptor;
            }
            MigrationReport migrationReport = this;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor2 = lazyAttributeLoadingInterceptor;
            if (lazyAttributeLoadingInterceptor != null && !lazyAttributeLoadingInterceptor.isAttributeLoaded("logs")) break block3;
            if (this.logs == null || this.logs instanceof PersistentCollection && !((PersistentCollection)this.logs).wasInitialized()) {
                this.$$_hibernate_collectionTracker.add("logs", -1);
            } else {
                this.$$_hibernate_collectionTracker.add("logs", this.logs.size());
            }
        }
    }

    public Long $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(Long l) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)l);
            return;
        }
        this.id = l;
    }

    public Long $$_hibernate_read_migrationId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.migrationId = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "migrationId", (Object)this.migrationId);
        }
        return this.migrationId;
    }

    public void $$_hibernate_write_migrationId(Long l) {
        if (!Objects.deepEquals(l, this.migrationId)) {
            this.$$_hibernate_trackChange("migrationId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.migrationId = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "migrationId", (Object)this.migrationId, (Object)l);
            return;
        }
        this.migrationId = l;
    }

    public Long $$_hibernate_read_processInstanceId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processInstanceId = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "processInstanceId", (Object)this.processInstanceId);
        }
        return this.processInstanceId;
    }

    public void $$_hibernate_write_processInstanceId(Long l) {
        if (!Objects.deepEquals(l, this.processInstanceId)) {
            this.$$_hibernate_trackChange("processInstanceId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processInstanceId = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "processInstanceId", (Object)this.processInstanceId, (Object)l);
            return;
        }
        this.processInstanceId = l;
    }

    public Instant $$_hibernate_read_startDate() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.startDate = (Instant)this.$$_hibernate_getInterceptor().readObject((Object)this, "startDate", (Object)this.startDate);
        }
        return this.startDate;
    }

    public void $$_hibernate_write_startDate(Instant instant) {
        if (!Objects.deepEquals(instant, this.startDate)) {
            this.$$_hibernate_trackChange("startDate");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.startDate = (Instant)this.$$_hibernate_getInterceptor().writeObject((Object)this, "startDate", (Object)this.startDate, (Object)instant);
            return;
        }
        this.startDate = instant;
    }

    public Instant $$_hibernate_read_endDate() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.endDate = (Instant)this.$$_hibernate_getInterceptor().readObject((Object)this, "endDate", (Object)this.endDate);
        }
        return this.endDate;
    }

    public void $$_hibernate_write_endDate(Instant instant) {
        if (!Objects.deepEquals(instant, this.endDate)) {
            this.$$_hibernate_trackChange("endDate");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.endDate = (Instant)this.$$_hibernate_getInterceptor().writeObject((Object)this, "endDate", (Object)this.endDate, (Object)instant);
            return;
        }
        this.endDate = instant;
    }

    public Boolean $$_hibernate_read_successful() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.successful = (Boolean)this.$$_hibernate_getInterceptor().readObject((Object)this, "successful", (Object)this.successful);
        }
        return this.successful;
    }

    public void $$_hibernate_write_successful(Boolean bl) {
        if (!Objects.deepEquals(bl, this.successful)) {
            this.$$_hibernate_trackChange("successful");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.successful = (Boolean)this.$$_hibernate_getInterceptor().writeObject((Object)this, "successful", (Object)this.successful, (Object)bl);
            return;
        }
        this.successful = bl;
    }

    public List $$_hibernate_read_logs() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.logs = (List)this.$$_hibernate_getInterceptor().readObject((Object)this, "logs", this.logs);
        }
        return this.logs;
    }

    public void $$_hibernate_write_logs(List list) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.logs = (List)this.$$_hibernate_getInterceptor().writeObject((Object)this, "logs", this.logs, (Object)list);
            return;
        }
        this.logs = list;
    }
}

