/*
 * Decompiled with CFR 0.152.
 */
package org.kie.processmigration.service;

import io.quarkus.runtime.Startup;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.kie.processmigration.model.Migration;
import org.kie.processmigration.model.exceptions.InvalidMigrationException;
import org.kie.processmigration.service.MigrationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Startup
@Singleton
public class RecoveryService {
    private static final Logger logger = LoggerFactory.getLogger(RecoveryService.class);
    @Inject
    MigrationService migrationService;

    @PostConstruct
    public void resumeMigrations() {
        logger.info("Resuming ongoing migrations ...");
        List<Migration> migrations = this.migrationService.findPending();
        migrations.forEach(m -> {
            try {
                this.migrationService.migrate((Migration)((Object)m));
            }
            catch (InvalidMigrationException e) {
                logger.warn("Unable to resume migration with id: " + m.getId(), (Throwable)e);
            }
        });
    }
}

