/*
 * Decompiled with CFR 0.152.
 */
package org.kie.processmigration.service.impl;

import io.quarkus.runtime.Startup;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.kie.processmigration.model.Migration;
import org.kie.processmigration.model.exceptions.InvalidMigrationException;
import org.kie.processmigration.model.exceptions.MigrationNotFoundException;
import org.kie.processmigration.service.MigrationService;
import org.kie.processmigration.service.SchedulerService;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Startup
public class SchedulerServiceImpl
implements SchedulerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerServiceImpl.class);
    @Inject
    Scheduler scheduler;

    @Override
    public void scheduleMigration(Migration migration) {
        JobDetail job = JobBuilder.newJob(MigrationJob.class).withIdentity(migration.getId().toString()).build();
        try {
            LOGGER.debug("Schedule migration for {}", (Object)migration.getId());
            this.scheduler.scheduleJob(job, this.buildTrigger(migration));
        }
        catch (SchedulerException e) {
            LOGGER.error("Unable to schedule migration for {}", (Object)migration.getId(), (Object)e);
        }
    }

    @Override
    public void reScheduleMigration(Migration migration) {
        try {
            LOGGER.debug("re-scheduling migration for {}", (Object)migration.getId());
            Trigger trigger = this.buildTrigger(migration);
            this.scheduler.rescheduleJob(trigger.getKey(), this.buildTrigger(migration));
        }
        catch (SchedulerException e) {
            LOGGER.error("Unable to re-schedule job for {}", (Object)migration.getId(), (Object)e);
        }
    }

    private Trigger buildTrigger(Migration migration) {
        TriggerBuilder builder = TriggerBuilder.newTrigger().withIdentity(migration.getId().toString());
        if (migration.getDefinition().getExecution() == null || migration.getDefinition().getExecution().getScheduledStartTime() == null) {
            builder = builder.startNow();
        } else {
            builder.startAt(Date.from(migration.getDefinition().getExecution().getScheduledStartTime()));
        }
        return builder.build();
    }

    @RegisterForReflection
    public static class MigrationJob
    implements Job {
        @Inject
        MigrationService migrationService;

        @Transactional
        public void execute(JobExecutionContext jobExecutionContext) {
            Long migrationId = Long.valueOf(jobExecutionContext.getJobDetail().getKey().getName());
            try {
                Migration migration = this.migrationService.get(migrationId);
                LOGGER.debug("Triggering migration job for {}", (Object)migrationId);
                this.migrationService.migrate(migration);
            }
            catch (InvalidMigrationException | MigrationNotFoundException e) {
                LOGGER.error("Unable to perform asynchronous migration", (Throwable)e);
                try {
                    jobExecutionContext.getScheduler().deleteJob(jobExecutionContext.getJobDetail().getKey());
                }
                catch (SchedulerException ex) {
                    LOGGER.error("Unable to delete job for failed migration {}", (Object)migrationId, (Object)ex);
                }
            }
        }
    }
}

