/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.ConfigurationException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public class RuntimeConfigSourceProvider
implements ConfigSourceProvider {
    private final String configSourceProviderClassName;

    public RuntimeConfigSourceProvider(String configSourceProviderClassName) {
        this.configSourceProviderClassName = configSourceProviderClassName;
    }

    public Iterable<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
        try {
            Class<?> configSourceProviderClass = forClassLoader.loadClass(this.configSourceProviderClassName);
            ConfigSourceProvider configSourceProvider = (ConfigSourceProvider)configSourceProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return configSourceProvider.getConfigSources(forClassLoader);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConfigurationException(e);
        }
    }
}

