/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.eclipse.transformer.action.Action;
import org.eclipse.transformer.action.ActionContext;

public interface ActionSelector {
    public List<Action> getActions();

    default public void addAction(Action action) {
        this.getActions().add(action);
    }

    default public void addActions(Collection<? extends Action> actions) {
        this.getActions().addAll(actions);
    }

    default public <ACTION extends Action> ACTION addUsing(Function<? super ActionContext, ACTION> init, ActionContext context) {
        Action action = (Action)init.apply(context);
        this.addAction(action);
        return (ACTION)action;
    }

    default public Action selectAction(String resourceName, File resourceFile) {
        for (Action action : this.getActions()) {
            if (!action.acceptResource(resourceName, resourceFile)) continue;
            return action;
        }
        return null;
    }

    default public Action acceptType(String actionTypeName) {
        for (Action action : this.getActions()) {
            if (!action.acceptType(actionTypeName)) continue;
            return action;
        }
        return null;
    }
}

