/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action;

import java.util.Arrays;
import java.util.function.Predicate;

public enum ActionType {
    RENAME("Rename Action", new String[0]),
    CLASS("Class Action", ".class"),
    MANIFEST("Manifest Action", "manifest.mf"),
    FEATURE("Feature Action", ".mf"),
    SERVICE_LOADER_CONFIG("Service Config Action", new String[0]),
    PROPERTIES("Properties Action", ".properties"),
    TEXT("Text Action", new String[0]),
    JAVA("Java Action", ".java"),
    JSP("JSP Action", ".jsp"),
    XML("XML Action", ".xml"),
    ZIP("Zip Action", ".zip"),
    JAR("Jar Action", ".jar"),
    WAR("WAR Action", ".war"),
    RAR("RAR Action", ".rar"),
    EAR("EAR Action", ".ear"),
    DIRECTORY("Directory Action", new String[0]);

    private final String name;
    private final Predicate<String> matcher;

    private ActionType(String name, String ... extensions) {
        this.name = name;
        this.matcher = Arrays.stream(extensions).map(this::extensionPredicate).reduce(Predicate::or).orElse(this::matchingUnsupported);
    }

    private Predicate<String> extensionPredicate(String extension) {
        int length = extension.length();
        return resourceName -> resourceName.regionMatches(true, resourceName.length() - length, extension, 0, length);
    }

    private boolean matchingUnsupported(String resourceName) {
        throw new UnsupportedOperationException(this.getName().concat(" does not support resource name matching"));
    }

    public Predicate<String> resourceNameMatcher() {
        return this.matcher;
    }

    public String getName() {
        return this.name;
    }

    public boolean matches(String tag) {
        return this.name().regionMatches(true, 0, tag, 0, tag.length());
    }
}

