/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import aQute.lib.io.IO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.eclipse.transformer.action.ByteData;
import org.eclipse.transformer.util.FileUtils;

public class ByteDataImpl
implements ByteData {
    private final String name;
    private final ByteBuffer buffer;
    private final Charset charset;

    public ByteDataImpl(String name, ByteBuffer buffer, Charset charset) {
        this.name = name;
        this.buffer = buffer;
        this.charset = charset;
    }

    public String toString() {
        return super.toString() + "(name=\"" + this.name + "\", buffer=" + this.buffer + ", charset=" + this.charset + ")";
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ByteBuffer buffer() {
        return this.buffer.duplicate();
    }

    @Override
    public int length() {
        return this.buffer.remaining();
    }

    @Override
    public InputStream stream() {
        return FileUtils.stream(this.buffer());
    }

    @Override
    public Reader reader() {
        return FileUtils.reader(this.buffer(), this.charset());
    }

    @Override
    public Charset charset() {
        return this.charset;
    }

    @Override
    public OutputStream writeTo(OutputStream outputStream) throws IOException {
        return IO.copy((ByteBuffer)this.buffer(), (OutputStream)outputStream);
    }

    @Override
    public ByteDataImpl copy() {
        return this.copy(this.name);
    }

    @Override
    public ByteDataImpl copy(String name) {
        return new ByteDataImpl(name, this.buffer(), this.charset());
    }
}

